package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.ResourceLink;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;

import java.util.List;

/**
 *
 */
public class CreateTomcatResourceLinksStep extends TomcatStepBase implements Step {

	private List<ResourceLink> resources;

	public CreateTomcatResourceLinksStep(TomcatServer target, String label, TomcatWarMapping warMapping, List<ResourceLink> resources) {
		super(target, warMapping);
		this.resources = resources;
		setDescription("Create Global JNDI Resources based on " + label + " on Tomcat server " + server + " on context " + contextRoot);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession s = server.connectToAdminHost();
		try {
			HostFile contextFile = s.getFile(getContextFilePathOnServer());
			ctx.logOutput("Creating JNDI Global definitions in context file " + contextFile.getPath() + " on " + server.getHost());
			TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(contextFile);
			contextFileUtils.addOrUpdateResources(resources);
			ctx.logOutput("Done.");
			return true;
		} finally {
			s.close();
		}
	}

	public List<ResourceLink> getResources() {
		return resources;
	}
}
