package com.xebialabs.deployit.plugin.tomcat.mapper;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**

 */
public abstract class WarMappingBasedTomcatServerMapper<S extends Serializable, M extends Mapping<? super S, ? super T>, T extends TomcatUnmanagedServer> extends
		StepGeneratingMapper<S, M, T> {
	private Mapper<War, TomcatWarMapping, T>[] tomcatServerMappers;

	public WarMappingBasedTomcatServerMapper(Change<Deployment> change, Mapper<War, TomcatWarMapping, T>... tomcatServerMappers) {
		super(change);
		this.tomcatServerMappers = tomcatServerMappers;


	}

	@Override
	protected void generateAdditionStepsForAddedMapping(S newMappingSource, M newMapping, T newMappingTarget, List<Step> steps) {
		Set<TomcatWarMapping> addedAndModifiedWarMappings = getAddedAndModifiedWarMappings();

		for (TomcatWarMapping warMapping : addedAndModifiedWarMappings) {
			if (warMapping.getTarget().equals(newMappingTarget)) {
				if (!StringUtils.isBlank(warMapping.getContextRoot())) {
					generateAdditionStepsForAddedMapping(newMappingSource, newMapping,newMappingTarget, warMapping, steps);
				} else {
					throw new ResolutionException("No war mapping with a set context root was found for " + warMapping.getSource());
				}
			}

		}
	}

	protected abstract void generateAdditionStepsForAddedMapping(S newMappingSource, M newMapping, T newMappingTarget, TomcatWarMapping warMapping,List<Step> steps) ;

	protected abstract void generateDeletionStepsForDeletedMapping(S oldMappingSource, M oldVersionOfModifiedMapping, T oldMappingTarget, TomcatWarMapping warMapping,List<Step> steps);


	@Override
	protected void generateDeletionStepsForDeletedMapping(S oldMappingSource, M oldVersionOfModifiedMapping, T oldMappingTarget, List<Step> steps) {
		Set<TomcatWarMapping> deletedAndModifiedMappings = getdeletedAndModifiedWarMappings();

		for (TomcatWarMapping warMapping : deletedAndModifiedMappings) {
			if (warMapping.getTarget().equals(oldMappingTarget)) {
				if (!StringUtils.isBlank(warMapping.getContextRoot())) {
					generateDeletionStepsForDeletedMapping(oldMappingSource,oldVersionOfModifiedMapping,oldMappingTarget,warMapping,steps);
				} else {
					throw new ResolutionException("No war mapping with a set context root was found for " + warMapping.getSource());
				}
			}

		}
	}

	private Set<TomcatWarMapping> getdeletedAndModifiedWarMappings() {
		Set<TomcatWarMapping> warMappings = Sets.newHashSet();
		for (Mapper<War, TomcatWarMapping, T> mapper : tomcatServerMappers) {
			warMappings.addAll(mapper.getOldMappings());
		}
		return warMappings;
	}

	private Set<TomcatWarMapping> getAddedAndModifiedWarMappings() {
		Set<TomcatWarMapping> warMappings = Sets.newHashSet();
		for (Mapper<War, TomcatWarMapping, T> mapper : tomcatServerMappers) {
			warMappings.addAll(mapper.getNewMappings());
		}
		return warMappings;
	}
}
