/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.ci.LoadBalancedServerAware;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.artifact.mapping.WarMapping;

import java.util.HashSet;
import java.util.Set;

@SuppressWarnings("serial")
@ConfigurationItem(description = "A mapping of a WAR to a Tomcat server")
public class TomcatWarMapping extends WarMapping<TomcatServer> {

	@ConfigurationItemProperty(description = "Explode the war file on tomcat server (does not work when using the Tomcat manager).")
	private boolean exploded;

	@ConfigurationItemProperty(required = false, description = "aaabsolute path of the directory where wars are deployed. Only needed when context path specified in the mapping is different from the war name", size = Size.DEFAULT)
	private String appBase;

	public TomcatWarMapping() {
		// default constructor
	}

	public TomcatWarMapping(War source, TomcatServer target, String virtualHost, String contextRoot) {
		super(source, target, virtualHost, contextRoot);
	}

	public TomcatWarMapping(War source, TomcatServer target, String virtualHost, String contextRoot, String appBase) {
		super(source, target, virtualHost, contextRoot);
		this.appBase = appBase;
	}

	public boolean isExploded() {
		return exploded;
	}

	public String getAppBase() {
		return appBase;
	}

	public void setAppBase(String appBase) {
		this.appBase = appBase;
	}

	public void setExploded(boolean exploded) {
		this.exploded = exploded;
	}

}
