package com.xebialabs.deployit.plugin.tomcat.ci;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.ConfigurationItemProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Map;


@SuppressWarnings("serial")
public class ResourceLink extends ResourceLinkValue implements Serializable {

	@ConfigurationItemProperty
	private String name;

	public ResourceLink() {

	}

	public ResourceLink(String name, String global, ResourceType type) {
		super(global,type);
		this.name = name;

	}

	public ResourceLink(String key, ResourceLinkValue value) {
		this(key, value.getGlobal(), value.getType());
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}


	public static Map<String,ResourceLinkValue> toMap(List<ResourceLink> list) {
		Map<String,ResourceLinkValue> result = Maps.newHashMap();
		for (ResourceLink l : list )  {
			result.put(l.getName(), l.getValue());
		}
		return result;

	}

	public ResourceLinkValue getValue() {
		return new ResourceLinkValue(global, type);
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (!(o instanceof ResourceLink)) return false;
		if (!super.equals(o)) return false;

		ResourceLink that = (ResourceLink) o;

		if (name != null ? !name.equals(that.name) : that.name != null) return false;

		return super.equals(o);
	}

	@Override
	public int hashCode() {
		int result = super.hashCode();
		result = 31 * result + (name != null ? name.hashCode() : 0);
		return result;
	}
}
