/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.mapper;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatDeployApplicationStep;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatUndeployApplicationStep;

public class WarToTomcatUnmanagedServerMapper extends StepGeneratingMapper<War, TomcatWarMapping, TomcatUnmanagedServer> {

	public WarToTomcatUnmanagedServerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(War newSource, TomcatWarMapping mapping, TomcatUnmanagedServer newTarget,
			List<Step> steps) {
		if (isAppBaseNeeded(newSource.getName(), mapping.getContextRoot()) && StringUtils.isBlank(mapping.getAppBase())) {
			throw new ResolutionException("Server " + newTarget.getLabel()
					+ " appBase must be specified when context root specified is different from war name");
		}

		steps.add(new TomcatDeployApplicationStep(newTarget, mapping));

	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(War oldSource, TomcatWarMapping mapping, TomcatUnmanagedServer oldTarget,
			List<Step> steps) {
			steps.add(new TomcatUndeployApplicationStep(oldTarget, mapping));
	}

	private boolean isAppBaseNeeded(String warName, String contextPath) {
		return !StringUtils.isBlank(contextPath) && !contextPath.equals(warName);
	}

}
