/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatDeploymentStepBase;

public class TomcatDeployApplicationStep
extends TomcatDeploymentStepBase {
    private static final String FILE_PART_EXTENSION = ".part";
    private boolean exploded = false;

    public TomcatDeployApplicationStep(TomcatUnmanagedServer target, TomcatWarMapping mapping) {
        super(target, mapping);
        this.setDescription("Deploy WAR file " + mapping.getSource() + " to Tomcat server " + (Object)((Object)this.server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.server.connectToAdminHost();
        try {
            boolean bl;
            HostSession lhs = Host.getLocalHost().getHostSession();
            try {
                HostFile sourceFile = lhs.getFile(this.artifact.getLocation());
                if (!this.exploded) {
                    HostFile partTargetTmpFile = rhs.getFile(this.getDeployedArtifactPath() + FILE_PART_EXTENSION);
                    ctx.logOutput("Copying application artifact to " + partTargetTmpFile.getPath() + " on " + this.server.getHost());
                    HostFileUtils.copyFile((HostFile)sourceFile, (HostFile)partTargetTmpFile);
                    HostFile targetDeployFile = rhs.getFile(this.getDeployedArtifactPath());
                    ctx.logOutput("Moving application artifact from " + partTargetTmpFile.getPath() + " to " + targetDeployFile.getPath() + " on " + this.server.getHost());
                    partTargetTmpFile.moveTo(targetDeployFile);
                } else {
                    String artifactTargetDirName = this.artifact.getName() + ".tmp";
                    HostFile targetTmpDir = rhs.getTempFile(artifactTargetDirName);
                    targetTmpDir.mkdirs();
                    ctx.logOutput("Unzipping application artifact to " + targetTmpDir.getPath() + " on " + this.server.getHost());
                    HostFileUtils.unzip((HostFile)sourceFile, (HostFile)targetTmpDir);
                    HostFile targetDeployDir = rhs.getFile(this.getExplodedWarTargetFileName());
                    ctx.logOutput("Moving application artifact from " + targetTmpDir.getPath() + " to " + targetDeployDir.getPath() + " on " + this.server.getHost());
                    targetTmpDir.moveTo(targetDeployDir);
                }
                if (this.isContextSet()) {
                    HostFile contextFile = rhs.getFile(this.getContextFilePathOnServer());
                    TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(contextFile);
                    if (!this.exploded) {
                        contextFileUtils.addOrUpdateContextPath(this.getDeployedArtifactPath());
                    } else {
                        contextFileUtils.addOrUpdateContextPath(this.getExplodedWarTargetFileName());
                    }
                }
                ctx.logOutput("Done.");
                bl = true;
            }
            catch (Throwable throwable) {
                lhs.close();
                throw throwable;
            }
            lhs.close();
            return bl;
        }
        finally {
            rhs.close();
        }
    }
}

