/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.tomcat.ci.ContextFiles;
import com.xebialabs.deployit.plugin.tomcat.ci.ContextFilesMapping;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.steps.CopyStep;
import com.xebialabs.deployit.steps.DeleteStep;
import java.io.File;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextFilesToTomcatServerMapper
extends StepGeneratingMapper<ContextFiles, ContextFilesMapping, TomcatServer> {
    public ContextFilesToTomcatServerMapper(Change<Deployment> change) {
        super(change, false);
    }

    protected void generateAdditionStepsForAddedMapping(ContextFiles newMappingSource, ContextFilesMapping m, TomcatServer newMappingTarget, List<Step> steps) {
        Map propertyMap = KeyValuePair.toMap((List)m.getKeyValuePairs());
        String targetDirectory = newMappingTarget.getContextWithoutVirtualHostDirPath();
        steps.add((Step)new CopyStep(Host.getLocalHost(), ((ContextFiles)((Object)m.getSource())).getLocation(), ((TomcatServer)((Object)m.getTarget())).getHost(), targetDirectory, propertyMap));
    }

    protected void generateDeletionStepsForDeletedMapping(ContextFiles oldMappingSource, ContextFilesMapping m, TomcatServer oldMappingTarget, List<Step> steps) {
        String targetDirectory = oldMappingTarget.getContextWithoutVirtualHostDirPath();
        for (File f : oldMappingSource.getFiles()) {
            String fileToDelete = new File(targetDirectory, f.getName()).getPath();
            steps.add((Step)new DeleteStep(((TomcatServer)((Object)m.getTarget())).getHost(), fileToDelete));
        }
    }
}

