/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.ci;

import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatUnmanagedServerReachabilityTestStep;
import com.xebialabs.deployit.step.CheckDirExistsStep;
import com.xebialabs.deployit.step.CheckFileExistenceStep;
import com.xebialabs.deployit.step.HostConnectionStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="Tomcat Server instance", discoverable=true, category="middleware")
public class TomcatUnmanagedServer
extends TomcatServer {
    @ConfigurationItemProperty(required=true, label="Base URL of the server", description="The base URL which will be used to check whether server is running, e.g. http://tomcat-6:8080", discoveryParam=true)
    private String baseUrl;
    @ConfigurationItemProperty(required=true, label="Tomcat start command", description="Command that should be executed to start the Tomcat server, e.g./opt/tomcat/bin/catalina.sh start.", size=ConfigurationItemProperty.Size.LARGE, discoveryParam=true)
    private String startCommand;
    @ConfigurationItemProperty(required=true, label="Tomcat stop command", description="Command that should be executed to stop the Tomcat server, e.g. /opt/tomat/bin/catalina.sh stop", size=ConfigurationItemProperty.Size.LARGE, discoveryParam=true)
    private String stopCommand;

    @Override
    public boolean isManaged() {
        return false;
    }

    @Override
    public HostSession connectToAdminHost() {
        return this.getHost().getHostSession();
    }

    @Override
    public String getDeployDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getTomcatHome() + fileSep + this.getAppBase();
    }

    @Override
    public String getContextWithoutVirtualHostDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getTomcatHome() + fileSep + "conf" + fileSep + this.getService() + fileSep + "localhost";
    }

    @Override
    public String getContextWithVirtualHostDirPath(String virtualHostName) {
        String fileSep = this.getHost().getFileSeparator();
        return this.getTomcatHome() + fileSep + "conf" + fileSep + this.getService() + fileSep + virtualHostName;
    }

    public String getStopCommand() {
        return this.stopCommand;
    }

    public void setStopCommand(String stopCommand) {
        this.stopCommand = stopCommand;
    }

    public String getStartCommand() {
        StringBuffer command = new StringBuffer();
        if (this.getHost().getOperatingSystemFamily() == OperatingSystemFamily.UNIX) {
            command.append("nohup ");
        }
        if (!StringUtils.isEmpty((String)this.startCommand)) {
            command.append(this.startCommand);
        }
        return command.toString();
    }

    public boolean isStartStopCommandAvailable() {
        return !StringUtils.isBlank((String)this.baseUrl) && !StringUtils.isBlank((String)this.startCommand) && !StringUtils.isBlank((String)this.stopCommand);
    }

    public void setStartCommand(String startCommand) {
        this.startCommand = startCommand;
    }

    private List<Step> getCheckSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add((Step)new HostConnectionStep(this.getHost()));
        steps.add((Step)new CheckDirExistsStep(this.getHost(), this.getTomcatHome()));
        steps.add(new TomcatUnmanagedServerReachabilityTestStep(this));
        String[] startCommands = StringUtils.split((String)this.startCommand);
        String[] stopCommands = StringUtils.split((String)this.stopCommand);
        steps.add((Step)new CheckFileExistenceStep(this.getHost(), startCommands[0], true, false, true));
        if (!stopCommands[0].equals(startCommands[0])) {
            steps.add((Step)new CheckFileExistenceStep(this.getHost(), stopCommands[0], true, false, true));
        }
        return steps;
    }

    @Override
    public TomcatUnmanagedServer discover(Map<String, Object> info, ChangePlan cp) {
        cp.addSteps(this.getCheckSteps());
        cp.execute(info);
        return this;
    }

    @Override
    public TomcatUnmanagedServer discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
        return this;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

