/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.ci;

import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatManagedServerReachabilityTestStep;
import com.xebialabs.deployit.step.HostConnectionStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="Tomcat Server instance", discoverable=true, category="middleware")
public class TomcatManagedServer
extends TomcatServer {
    @ConfigurationItemProperty(required=true, label="Manager App URL", description="URL of the manager app URL, e.g. http://tomcat-6:8080/manager", size=ConfigurationItemProperty.Size.LARGE, discoveryParam=true)
    private String managerAppUrl;
    @ConfigurationItemProperty(required=true, label="Tomcat manager username", description="Username to be used for the manager application deployed on tomcat", size=ConfigurationItemProperty.Size.DEFAULT, discoveryParam=true)
    private String managerUsername;
    @ConfigurationItemProperty(required=true, label="Tomcat manager password", description="Password to be used for the manager application deployed on tomcat", size=ConfigurationItemProperty.Size.DEFAULT, password=true, discoveryParam=true)
    private String managerPassword;

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public HostSession connectToAdminHost() {
        return this.getHost().getHostSession();
    }

    public String getManagerUsername() {
        return this.managerUsername;
    }

    public void setManagerUsername(String managerUsername) {
        this.managerUsername = managerUsername;
    }

    public String getManagerPassword() {
        return this.managerPassword;
    }

    public void setManagerPassword(String managerPassword) {
        this.managerPassword = managerPassword;
    }

    private List<Step> getCheckSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add((Step)new HostConnectionStep(this.getHost()));
        steps.add(new TomcatManagedServerReachabilityTestStep(this));
        return steps;
    }

    @Override
    public TomcatManagedServer discover(Map<String, Object> info, ChangePlan cp) {
        cp.addSteps(this.getCheckSteps());
        cp.execute(info);
        return this;
    }

    @Override
    public TomcatManagedServer discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
        return this;
    }

    public String getManagerAppUrl() {
        return this.managerAppUrl;
    }

    public void setManagerAppUrl(String managerAppUrl) {
        this.managerAppUrl = managerAppUrl;
    }
}

