/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat;

import com.xebialabs.deployit.plugin.tomcat.ci.TomcatManagedServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;

public class TomcatManagerAppUtils {
    private TomcatManagedServer server;
    private String baseUrl;

    public TomcatManagerAppUtils(TomcatManagedServer server) {
        if (server != null) {
            this.server = server;
            this.baseUrl = server.getManagerAppUrl();
        }
    }

    public String deploy(String contextRoot, String warLocation) throws IOException {
        String url = this.baseUrl + "/deploy?path=/" + contextRoot + "&war=file:" + warLocation;
        return this.executeManagerAppCommand(url);
    }

    public boolean checkTomcatReachable(String url) {
        return this.isTomcatReachableAndRunning(url);
    }

    public boolean checkApplicationIsDeployed(String applicationName) {
        String execetionResultStr;
        String url = this.baseUrl + "/list";
        try {
            execetionResultStr = this.executeManagerAppCommand(url);
        }
        catch (HttpException e) {
            throw new RuntimeException("error found in calling manager URL " + url, e);
        }
        catch (IOException e) {
            throw new RuntimeException("error found in calling manager URL " + url, e);
        }
        return execetionResultStr.contains("/" + applicationName + ":running");
    }

    public String undeploy(String contextRoot) throws IOException {
        String url = this.baseUrl + "/undeploy?path=/" + contextRoot;
        return this.executeManagerAppCommand(url);
    }

    private String executeManagerAppCommand(String url) throws IOException, HttpException {
        HttpMethod method = this.invokeClientWithWithMangerUrl(url, true);
        return this.getResponseFromUrl(method);
    }

    private HttpMethod invokeClientWithWithMangerUrl(String url, boolean useManagerCredentials) throws IOException, HttpException {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url);
        if (useManagerCredentials) {
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.server.getManagerUsername(), this.server.getManagerPassword());
            client.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
            method.setDoAuthentication(true);
        }
        int status = 0;
        status = client.executeMethod((HttpMethod)method);
        if (status != 200 && status != 404) {
            throw new RuntimeException("Can't access the manager app from URL " + url + ". HTTP status: " + status);
        }
        return method;
    }

    private boolean isTomcatReachableAndRunning(String url) {
        Header[] responseHeaders;
        HttpMethod method;
        try {
            method = this.invokeClientWithWithMangerUrl(url, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        for (Header header : responseHeaders = method.getResponseHeaders()) {
            if (!header.getValue().contains("Apache-Coyote")) continue;
            return true;
        }
        return false;
    }

    private String getResponseFromUrl(HttpMethod method) throws IOException {
        String readLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
        StringBuffer responseBody = new StringBuffer();
        while ((readLine = reader.readLine()) != null) {
            responseBody.append(readLine + "\n");
        }
        reader.close();
        method.releaseConnection();
        return responseBody.toString();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

