/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatManagerAppUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatManagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatDeploymentStepBase;
import java.io.IOException;

public class TomcatHttpBasedUndeployApplicationStep
extends TomcatDeploymentStepBase {
    public TomcatHttpBasedUndeployApplicationStep(TomcatServer oldTarget, TomcatWarMapping mapping) {
        super(oldTarget, mapping);
        this.setDescription("Undeploy WAR file " + mapping.getSource() + " from Tomcat server " + (Object)((Object)oldTarget) + " using manager application");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = null;
        try {
            rhs = this.server.getHost().getHostSession();
            String deploymentResult = this.undeployUsingManagerApp(ctx);
            if (!deploymentResult.startsWith("OK")) {
                boolean bl = false;
                return bl;
            }
            this.removeAppContextFile(rhs);
            ctx.logOutput("Done.");
            boolean bl = true;
            return bl;
        }
        finally {
            rhs.close();
        }
    }

    private void removeAppContextFile(HostSession rhs) {
        if (this.isContextSet()) {
            HostFile contextFile = rhs.getFile(this.getContextFilePathOnServer());
            contextFile.delete();
        }
    }

    private String undeployUsingManagerApp(StepExecutionContext ctx) {
        String deploymentResult = "";
        try {
            TomcatManagerAppUtils managerAppUtils = new TomcatManagerAppUtils((TomcatManagedServer)this.server);
            ctx.logOutput("Undeploying " + this.getArtifactTargetFileName() + " using manager app url " + managerAppUtils.getBaseUrl());
            String contextRootPath = this.isContextSet() ? this.contextRoot : this.artifact.getName();
            deploymentResult = managerAppUtils.undeploy(contextRootPath);
            ctx.logOutput(deploymentResult);
        }
        catch (IOException exc) {
            ctx.logError("Cannot undeploy " + this.mapping.getSource() + " from manager of " + (Object)((Object)this.server), (Throwable)exc);
        }
        return deploymentResult;
    }
}

