/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatDeploymentStepBase;

public class TomcatUnDeployApplicationStep
extends TomcatDeploymentStepBase {
    public TomcatUnDeployApplicationStep(TomcatServer oldTarget, War oldSource) {
        this(oldTarget, oldSource, "");
    }

    public TomcatUnDeployApplicationStep(TomcatServer oldTarget, War oldSource, String contextPath) {
        super(oldTarget, (NamedDeployableArtifact)oldSource, contextPath);
        this.setDescription("Undeploy WAR file " + oldSource + " from Tomcat server " + (Object)((Object)oldTarget));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.server.connectToAdminHost();
        try {
            HostFile targetDeployFile = rhs.getFile(this.getDeployedArtifactPath());
            ctx.logOutput("Removing application artifact from " + targetDeployFile.getPath() + " on " + this.server.getHost());
            targetDeployFile.delete();
            if (!this.isContextSet()) {
                String explodedWarDirectoryName = this.getExplodedWarTargetFileName();
                HostFile targetExplodedWar = rhs.getFile(explodedWarDirectoryName);
                ctx.logOutput("Removing application exploded directory " + targetExplodedWar.getPath() + " on " + this.server.getHost());
                targetExplodedWar.deleteRecursively();
            } else {
                HostFile contextFile = rhs.getFile(this.getContextFilePathOnServer());
                contextFile.delete();
            }
            ctx.logOutput("Done.");
            boolean bl = true;
            return bl;
        }
        finally {
            rhs.close();
        }
    }
}

