/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatManagerAppUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatDeploymentStepBase;
import java.io.IOException;

public class TomcatHttpBasedUnDeployApplicationStep
extends TomcatDeploymentStepBase {
    public TomcatHttpBasedUnDeployApplicationStep(TomcatServer oldTarget, War oldSource) {
        this(oldTarget, oldSource, "");
    }

    public TomcatHttpBasedUnDeployApplicationStep(TomcatServer oldTarget, War oldSource, String contextPath) {
        super(oldTarget, (NamedDeployableArtifact)oldSource, contextPath);
        this.setDescription("Undeploy WAR file " + oldSource + " from Tomcat server " + (Object)((Object)oldTarget) + " using manager application");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = null;
        try {
            rhs = this.server.getHost().getHostSession();
            TomcatManagerAppUtils managerAppUtils = new TomcatManagerAppUtils(this.server);
            ctx.logOutput("Undeploying " + this.getArtifactTargetFileName() + " using manager app url " + managerAppUtils.getBaseUrl());
            HostFile targetDeployFile = rhs.getFile(this.getDeployedArtifactPath());
            ctx.logOutput("Removing application artifact from " + targetDeployFile.getPath() + " on " + this.server.getHost());
            targetDeployFile.delete();
            String deploymentResult = "";
            try {
                String contextRootPath = this.isContextSet() ? this.contextRoot : this.artifact.getName();
                deploymentResult = managerAppUtils.undeploy(contextRootPath);
                ctx.logOutput(deploymentResult);
            }
            catch (IOException e) {
                ctx.logError(e.getMessage());
                boolean bl = false;
                rhs.close();
                return bl;
            }
            if (deploymentResult.startsWith("OK")) {
                if (this.isContextSet()) {
                    HostFile contextFile = rhs.getFile(this.getContextFilePathOnServer());
                    contextFile.delete();
                }
            } else {
                boolean bl = false;
                return bl;
            }
            ctx.logOutput("Done.");
            boolean bl = true;
            return bl;
        }
        finally {
            rhs.close();
        }
    }
}

