/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.TomcatManagerAppUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatDeploymentStepBase;
import java.io.IOException;

public class TomcatHttpBasedDeployApplicationStep
extends TomcatDeploymentStepBase {
    private War war;

    public TomcatHttpBasedDeployApplicationStep(TomcatServer target, War war) {
        this(target, war, "");
    }

    public TomcatHttpBasedDeployApplicationStep(TomcatServer target, War war, String contextRoot) {
        super(target, (NamedDeployableArtifact)war, contextRoot);
        this.war = war;
        this.setDescription("Deploy WAR file " + war + " to Tomcat server " + (Object)((Object)this.server) + " using manager application");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.server.connectToAdminHost();
        try {
            HostSession lhs = HostSessionFactory.getHostSession((Host)Host.getLocalHost());
            try {
                String deployedWarPath;
                HostFile sourceFile = lhs.getFile(this.artifact.getLocation());
                String artifactTargetFileName = this.getArtifactTargetFileName();
                HostFile targetTmpFile = rhs.getTempFile(artifactTargetFileName);
                ctx.logOutput("Copying application artifact to " + targetTmpFile.getPath() + " on " + this.server.getHost());
                HostFileUtils.copyFile((HostFile)sourceFile, (HostFile)targetTmpFile);
                HostFile deployedWarFile = rhs.getFile(this.getDeployedArtifactPath());
                HostFileUtils.copyFile((HostFile)targetTmpFile, (HostFile)deployedWarFile);
                TomcatManagerAppUtils managerAppUtils = new TomcatManagerAppUtils(this.server);
                ctx.logOutput("Deploying " + this.getArtifactTargetFileName() + " using manager app url " + managerAppUtils.getBaseUrl());
                if (this.isContextSet()) {
                    HostFile contextFile = rhs.getFile(this.getContextFilePathOnServer());
                    TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(contextFile);
                    contextFileUtils.addOrUpdateContextPath(this.server.getAppBase() + this.server.getHost().getFileSeparator() + artifactTargetFileName);
                    deployedWarPath = deployedWarFile.getPath();
                } else {
                    deployedWarPath = targetTmpFile.getPath();
                }
                String contextRootPath = this.isContextSet() ? this.contextRoot : this.artifact.getName();
                String deploymentResult = managerAppUtils.deploy(contextRootPath, deployedWarPath);
                ctx.logOutput(deploymentResult);
                if (deploymentResult.startsWith("OK")) {
                    ctx.logOutput("Done.");
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
                ctx.logError(e.getMessage());
            }
            finally {
                lhs.close();
            }
        }
        finally {
            rhs.close();
        }
        return false;
    }
}

