/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatStepBase;
import org.apache.commons.lang.StringUtils;

public abstract class TomcatDeploymentStepBase
extends TomcatStepBase {
    protected NamedDeployableArtifact artifact;

    protected TomcatDeploymentStepBase(TomcatServer server, NamedDeployableArtifact artifact, String contextRoot) {
        super(server, contextRoot);
        this.artifact = artifact;
    }

    protected String getArtifactTargetFileName() {
        String targetFileName = this.artifact.getName();
        if (!(this.artifact instanceof War)) {
            throw new IllegalArgumentException("Artifact " + this.artifact + " is not a WAR");
        }
        targetFileName = targetFileName + ".war";
        return targetFileName;
    }

    protected String getExplodedWarTargetFileName() {
        if (this.artifact instanceof War) {
            return this.artifact.getName();
        }
        throw new IllegalArgumentException("Artifact " + this.artifact + " is not a WAR");
    }

    protected String getDeployedArtifactPath() {
        if (!StringUtils.isBlank((String)this.contextRoot)) {
            return this.server.getAppBase() + this.server.getHost().getFileSeparator() + this.getArtifactTargetFileName();
        }
        return this.server.getDeployDirPath() + this.server.getHost().getFileSeparator() + this.getArtifactTargetFileName();
    }
}

