/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatDeploymentStepBase;

public class TomcatDeployApplicationStep
extends TomcatDeploymentStepBase {
    public TomcatDeployApplicationStep(TomcatServer target, War war) {
        super(target, (NamedDeployableArtifact)war, "");
        this.setDescription("Deploy WAR file " + war + " to Tomcat server " + (Object)((Object)this.server));
    }

    public TomcatDeployApplicationStep(TomcatServer target, War war, String contextPath) {
        super(target, (NamedDeployableArtifact)war, contextPath);
        this.setDescription("Deploy WAR file " + war + " to Tomcat server " + (Object)((Object)this.server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.server.connectToAdminHost();
        try {
            boolean bl;
            HostSession lhs = HostSessionFactory.getHostSession((Host)Host.getLocalHost());
            try {
                HostFile sourceFile = lhs.getFile(this.artifact.getLocation());
                String artifactTargetFileName = this.getArtifactTargetFileName();
                HostFile targetTmpFile = rhs.getTempFile(artifactTargetFileName);
                ctx.logOutput("Copying application artifact to " + targetTmpFile.getPath() + " on " + this.server.getHost());
                HostFileUtils.copyFile((HostFile)sourceFile, (HostFile)targetTmpFile);
                HostFile targetDeployFile = rhs.getFile(this.getDeployedArtifactPath());
                ctx.logOutput("Moving application artifact from " + targetTmpFile.getPath() + " to " + targetDeployFile.getPath() + " on " + this.server.getHost());
                targetTmpFile.moveTo(targetDeployFile);
                if (this.isContextSet()) {
                    HostFile contextFile = rhs.getFile(this.getContextFilePathOnServer());
                    TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(contextFile);
                    contextFileUtils.addOrUpdateContextPath(this.server.getAppBase() + this.server.getHost().getFileSeparator() + artifactTargetFileName);
                }
                ctx.logOutput("Done.");
                bl = true;
            }
            catch (Throwable throwable) {
                lhs.close();
                throw throwable;
            }
            lhs.close();
            return bl;
        }
        finally {
            rhs.close();
        }
    }
}

