/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatDataSource;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatStepBase;

public class CreateTomcatDataSourceStep
extends TomcatStepBase {
    private TomcatDataSource dataSource;

    public CreateTomcatDataSourceStep(TomcatServer server, TomcatDataSource dataSource, String contextRoot) {
        super(server, contextRoot);
        this.dataSource = dataSource;
        this.setDescription("Create datasource " + (Object)((Object)dataSource) + " on Tomcat server " + (Object)((Object)server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession s = this.server.connectToAdminHost();
        try {
            HostFile dsFile = s.getFile(this.getContextFilePathOnServer());
            ctx.logOutput("Creating datasource definition in context file " + dsFile.getPath() + " on " + this.server.getHost());
            TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(dsFile);
            contextFileUtils.addOrUpdateDataSource(this.dataSource);
            ctx.logOutput("Done.");
            boolean bl = true;
            return bl;
        }
        finally {
            s.close();
        }
    }
}

