/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.mapper.DatasourceToTomcatServerMapper;
import com.xebialabs.deployit.plugin.tomcat.mapper.WarToTomcatServerMapper;
import com.xebialabs.deployit.plugin.tomcat.mapper.WarToTomcatServerWithManagerMapper;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatStartServerStep;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatStopServerStep;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatWaitStep;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatDeploymentRunBook
extends SingleTypeHandlingRunBook<Deployment> {
    public TomcatDeploymentRunBook() {
        super(Deployment.class);
    }

    protected void resolve(Change<Deployment> change, ChangePlan changePlan, List<Step> steps) {
        WarToTomcatServerMapper warToServerMapper = new WarToTomcatServerMapper(change);
        WarToTomcatServerWithManagerMapper warToServerWithManagerMapper = new WarToTomcatServerWithManagerMapper(change);
        DatasourceToTomcatServerMapper datasourceMapper = new DatasourceToTomcatServerMapper(change, new Mapper[]{warToServerMapper});
        HashSet<TomcatServer> affectedServers = new HashSet<TomcatServer>();
        affectedServers.addAll(warToServerMapper.getAffectedTargets());
        this.checkForServerConfigurationErrors(affectedServers);
        if (!this.isTomcatDeployment(warToServerMapper)) {
            return;
        }
        this.stopServers(affectedServers, steps);
        datasourceMapper.generateDeletionSteps(steps);
        warToServerMapper.generateDeletionSteps(steps);
        datasourceMapper.generateAdditionSteps(steps);
        warToServerMapper.generateAdditionSteps(steps);
        this.startServers(affectedServers, steps);
        warToServerWithManagerMapper.generateDeletionSteps(steps);
        warToServerWithManagerMapper.generateAdditionSteps(steps);
    }

    private void checkForServerConfigurationErrors(Set<TomcatServer> affectedServers) {
        for (TomcatServer server : affectedServers) {
            if (server.isManagerAppAvailable() || server.isStartStopCommandAvailable()) continue;
            throw new ResolutionException("Server " + server.getLabel() + " has neither start/stop commands nor manager app info configured");
        }
    }

    private boolean isTomcatDeployment(WarToTomcatServerMapper warToServerMapper) {
        HashSet allServers = new HashSet();
        allServers.addAll(warToServerMapper.getAllTargets());
        return !allServers.isEmpty();
    }

    private void stopServers(Set<TomcatServer> servers, List<Step> steps) {
        boolean toWait = false;
        for (TomcatServer eachServer : servers) {
            if (eachServer.isManagerAppAvailable()) continue;
            steps.add(new TomcatStopServerStep(eachServer));
            toWait = true;
        }
        if (toWait) {
            steps.add(new TomcatWaitStep());
        }
    }

    private void startServers(Set<TomcatServer> servers, List<Step> steps) {
        for (TomcatServer eachServer : servers) {
            if (eachServer.isManagerAppAvailable()) continue;
            steps.add(new TomcatStartServerStep(eachServer));
        }
    }
}

