/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.artifact.mapping.WarMapping;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatDeployApplicationStep;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatUnDeployApplicationStep;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarToTomcatServerMapper
extends StepGeneratingMapper<War, WarMapping, TomcatServer> {
    public WarToTomcatServerMapper(Change<Deployment> change) {
        super(change);
    }

    protected void generateAdditionStepsForAddedMapping(War newSource, WarMapping mapping, TomcatServer newTarget, List<Step> steps) {
        if (!newTarget.isManagerAppAvailable()) {
            if (!StringUtils.isBlank((String)mapping.getContextRoot()) && StringUtils.isBlank((String)newTarget.getAppBase())) {
                throw new ResolutionException("Server " + newTarget.getLabel() + " appBase must be specified when context path is specified");
            }
            if (!StringUtils.isBlank((String)mapping.getContextRoot())) {
                steps.add(new TomcatDeployApplicationStep(newTarget, newSource, mapping.getContextRoot()));
            } else {
                steps.add(new TomcatDeployApplicationStep(newTarget, newSource));
            }
        }
    }

    protected void generateDeletionStepsForDeletedMapping(War oldSource, WarMapping mapping, TomcatServer oldTarget, List<Step> steps) {
        if (!oldTarget.isManagerAppAvailable()) {
            if (!StringUtils.isBlank((String)mapping.getContextRoot())) {
                steps.add(new TomcatUnDeployApplicationStep(oldTarget, oldSource, mapping.getContextRoot()));
            } else {
                steps.add(new TomcatUnDeployApplicationStep(oldTarget, oldSource));
            }
        }
    }
}

