/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.artifact.mapping.WarMapping;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatDataSource;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.step.CreateTomcatDataSourceStep;
import com.xebialabs.deployit.plugin.tomcat.step.DestroyTomcatDataSourceStep;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasourceToTomcatServerMapper
extends MappingAgnosticStepGeneratingMapper<TomcatDataSource, TomcatServer> {
    private Mapper<War, WarMapping, TomcatServer>[] tomcatServerMappers;

    public DatasourceToTomcatServerMapper(Change<Deployment> change, Mapper<War, WarMapping, TomcatServer> ... tomcatServerMappers) {
        super(change);
        this.tomcatServerMappers = tomcatServerMappers;
    }

    protected void generateAdditionStepsForAddedMapping(TomcatDataSource newMappingSource, TomcatServer newMappingTarget, List<Step> steps) {
        Set<WarMapping> addedAndModifiedWarMappings = this.getAddedAndModifiedWarMappings();
        for (WarMapping warMapping : addedAndModifiedWarMappings) {
            if (!warMapping.getTarget().equals((Object)newMappingTarget)) continue;
            if (!StringUtils.isBlank((String)warMapping.getContextRoot())) {
                steps.add(new CreateTomcatDataSourceStep(newMappingTarget, newMappingSource, warMapping.getContextRoot()));
                continue;
            }
            throw new ResolutionException("No war mapping with a set context root was found for " + warMapping.getSource());
        }
    }

    protected void generateDeletionStepsForDeletedMapping(TomcatDataSource oldMappingSource, TomcatServer oldMappingTarget, List<Step> steps) {
        Set<WarMapping> deletedAndModifiedMappings = this.getdeletedAndModifiedWarMappings();
        for (WarMapping warMapping : deletedAndModifiedMappings) {
            if (!warMapping.getTarget().equals((Object)oldMappingTarget)) continue;
            if (!StringUtils.isBlank((String)warMapping.getContextRoot())) {
                steps.add(new DestroyTomcatDataSourceStep(oldMappingTarget, oldMappingSource, warMapping.getContextRoot()));
                continue;
            }
            throw new ResolutionException("No war mapping with a set context root was found for " + warMapping.getSource());
        }
    }

    private Set<WarMapping> getdeletedAndModifiedWarMappings() {
        HashSet<WarMapping> warMappings = new HashSet<WarMapping>();
        for (Mapper<War, WarMapping, TomcatServer> mapper : this.tomcatServerMappers) {
            warMappings.addAll(mapper.getOldMappings());
        }
        return warMappings;
    }

    private Set<WarMapping> getAddedAndModifiedWarMappings() {
        HashSet<WarMapping> warMappings = new HashSet<WarMapping>();
        for (Mapper<War, WarMapping, TomcatServer> mapper : this.tomcatServerMappers) {
            warMappings.addAll(mapper.getNewMappings());
        }
        return warMappings;
    }
}

