/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.ci.artifact.mapping.WarMapping;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.ci.AccessMethod;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

@ConfigurationItem(description="Tomcat Server instance", targetForMappingTypes={WarMapping.class})
public class TomcatServer
extends BaseConfigurationItem {
    public static final int DEPLOYMENT_COMPLETION_WAIT_TIME_MILLIS = 3000;
    @ConfigurationItemProperty(required=true, label="Tomcat server host", description="Host on which the Tomcat server is running.")
    private Host host;
    @ConfigurationItemProperty(required=true, description="Port for the Tomcat Server, default is 8080")
    private int port;
    @ConfigurationItemProperty(required=true, description="Protocol to be used for accessing the tomcat server")
    private AccessMethod accessMethod;
    @ConfigurationItemProperty(required=true, label="Tomcat installation location", description="Place where Tomcat is installed such as /opt/apache-tomcat-6.0.24.", size=ConfigurationItemProperty.Size.LARGE)
    private String tomcatHome;
    @ConfigurationItemProperty(required=false, label="Tomcat stop command", description="Command that should be executed to stop the Tomcat server, e.g. /opt/tomat/bin/catalina.sh stop", size=ConfigurationItemProperty.Size.LARGE)
    private String stopCommand;
    @ConfigurationItemProperty(required=false, label="Tomcat start command", description="Command that should be executed to start the Tomcat server, e.g./opt/tomcat/bin/catalina.sh start.", size=ConfigurationItemProperty.Size.LARGE)
    private String startCommand;
    @ConfigurationItemProperty(required=false, label="Manager application context", description="relative context path for tomcat manager application, e.g. /manager", size=ConfigurationItemProperty.Size.DEFAULT)
    private String managerAppContext;
    @ConfigurationItemProperty(required=false, label="Tomcat manager username", description="Username to be used for the manager application deployed on tomcat", size=ConfigurationItemProperty.Size.DEFAULT)
    private String managerUsername;
    @ConfigurationItemProperty(required=false, label="Tomcat manager password", description="Password to be used for the manager application deployed on tomcat", size=ConfigurationItemProperty.Size.DEFAULT, password=true)
    private String managerPassword;
    @ConfigurationItemProperty(required=false, description="absolute path of the directory where wars are deployed", size=ConfigurationItemProperty.Size.DEFAULT)
    private String appBase;

    public HostSession connectToAdminHost() {
        return this.getHost().getHostSession();
    }

    public String getDeployDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getTomcatHome() + fileSep + "webapps";
    }

    public String getContextWithoutVirtualHostDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getTomcatHome() + fileSep + "conf" + fileSep + "Catalina" + fileSep + "localhost";
    }

    public String getContextWithVirtualHostDirPath(String virtualHostName) {
        String fileSep = this.getHost().getFileSeparator();
        return this.getTomcatHome() + fileSep + "conf" + fileSep + "Catalina" + fileSep + virtualHostName;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getStopCommand() {
        return this.stopCommand;
    }

    public void setStopCommand(String stopCommand) {
        this.stopCommand = stopCommand;
    }

    public String getStartCommand() {
        StringBuffer command = new StringBuffer();
        if (this.getHost().getOperatingSystemFamily() == OperatingSystemFamily.UNIX) {
            command.append("nohup ");
        }
        if (!StringUtils.isEmpty((String)this.startCommand)) {
            command.append(this.startCommand);
        }
        return command.toString();
    }

    public boolean isReachable() {
        boolean reachable = false;
        try {
            URL tomcatHomePageUrl = new URL(this.accessMethod.getValue() + "://" + this.getHost().getAddress() + ":" + this.getPort());
            BufferedReader in = new BufferedReader(new InputStreamReader(tomcatHomePageUrl.openStream()));
            in.readLine();
            in.close();
            reachable = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reachable;
    }

    public boolean isStartStopCommandAvailable() {
        return !StringUtils.isBlank((String)this.startCommand) && !StringUtils.isBlank((String)this.stopCommand);
    }

    public boolean isManagerAppAvailable() {
        return !StringUtils.isBlank((String)this.managerAppContext) && !StringUtils.isBlank((String)this.managerUsername) && !StringUtils.isBlank((String)this.managerPassword);
    }

    public void setStartCommand(String startCommand) {
        this.startCommand = startCommand;
    }

    public String getTomcatHome() {
        return this.tomcatHome;
    }

    public void setTomcatHome(String tomcatHome) {
        this.tomcatHome = tomcatHome;
    }

    public int getPort() {
        return this.port != 0 ? this.port : 8080;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getManagerUsername() {
        return this.managerUsername;
    }

    public void setManagerUsername(String managerUsername) {
        this.managerUsername = managerUsername;
    }

    public String getManagerPassword() {
        return this.managerPassword;
    }

    public void setManagerPassword(String managerPassword) {
        this.managerPassword = managerPassword;
    }

    public AccessMethod getAccessMethod() {
        return this.accessMethod;
    }

    public void setAccessMethod(AccessMethod accessMethod) {
        this.accessMethod = accessMethod;
    }

    public String getManagerAppContext() {
        return this.managerAppContext;
    }

    public void setManagerAppContext(String managerAppContext) {
        this.managerAppContext = managerAppContext;
    }

    public String getAppBase() {
        return this.appBase;
    }

    public void setAppBase(String appBase) {
        this.appBase = appBase;
    }
}

