/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat;

import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;

public class TomcatManagerAppUtils {
    private TomcatServer server;
    private String baseUrl;

    public TomcatManagerAppUtils(TomcatServer server) {
        this.server = server;
        this.baseUrl = server.getAccessMethod().getValue() + "://" + server.getHost().getAddress() + ":" + server.getPort() + "/" + server.getManagerAppContext();
    }

    public String deploy(String contextRoot, String warLocation) throws IOException {
        String url = this.baseUrl + "/deploy?path=/" + contextRoot + "&war=file:" + warLocation;
        return this.executeManagerAppCommand(url);
    }

    public boolean checkApplicationIsDeployed(String applicationName) {
        String execetionResultStr;
        String url = this.baseUrl + "/list";
        try {
            execetionResultStr = this.executeManagerAppCommand(url);
        }
        catch (HttpException e) {
            throw new RuntimeException("error found in calling manager URL " + url, e);
        }
        catch (IOException e) {
            throw new RuntimeException("error found in calling manager URL " + url, e);
        }
        return execetionResultStr.contains(applicationName);
    }

    public String undeploy(String contextRoot) throws IOException {
        String url = this.baseUrl + "/undeploy?path=/" + contextRoot;
        return this.executeManagerAppCommand(url);
    }

    private String executeManagerAppCommand(String url) throws IOException, HttpException {
        HttpMethod method = this.invokeClientWithUrl(url);
        return this.getResponseFromUrl(method);
    }

    private HttpMethod invokeClientWithUrl(String url) throws IOException, HttpException {
        HttpClient client = new HttpClient();
        if (StringUtils.isNotBlank((String)this.server.getManagerUsername()) && StringUtils.isNotBlank((String)this.server.getManagerPassword())) {
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.server.getManagerUsername(), this.server.getManagerPassword());
            client.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        }
        GetMethod method = new GetMethod(url);
        method.setDoAuthentication(true);
        int status = 0;
        status = client.executeMethod((HttpMethod)method);
        if (status != 200) {
            throw new RuntimeException("Can't access the manager app from URL " + url + ". HTTP status: " + status);
        }
        return method;
    }

    private String getResponseFromUrl(HttpMethod method) throws IOException {
        String readLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
        StringBuffer responseBody = new StringBuffer();
        while (!StringUtils.isBlank((String)(readLine = reader.readLine()))) {
            responseBody.append(readLine + "\n");
        }
        reader.close();
        method.releaseConnection();
        return responseBody.toString();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

