/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatDataSource;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class TomcatContextFileUtils {
    private HostFile contextFile;

    public TomcatContextFileUtils(HostFile contextFile) {
        this.contextFile = contextFile;
    }

    public boolean exists() {
        return this.contextFile.exists();
    }

    public boolean delete() {
        return this.contextFile.delete();
    }

    public void addOrUpdateContextPath(String docBase) {
        Document doc = this.getDocument();
        this.findAndRemoveExistingDocBase(doc);
        Element contextElement = this.getOrCreateContext(doc);
        contextElement.addAttribute("docBase", docBase);
        this.saveDocumentInContextFile(doc);
    }

    public void addOrUpdateDataSource(TomcatDataSource ds) {
        Document doc = this.getDocument();
        this.findAndRemoveExistingDatasource(ds, doc);
        Element context = this.getOrCreateContext(doc);
        Element newResourceDSElement = context.addElement("Resource");
        newResourceDSElement.addAttribute("name", ds.getJndiName());
        newResourceDSElement.addAttribute("url", ds.getConnectionUrl());
        newResourceDSElement.addAttribute("auth", "Container");
        newResourceDSElement.addAttribute("type", "javax.sql.DataSource");
        newResourceDSElement.addAttribute("username", ds.getUsername());
        newResourceDSElement.addAttribute("password", ds.getPassword());
        newResourceDSElement.addAttribute("driverClassName", ds.getDriverClass());
        if (ds.getMaxActive() > 0) {
            newResourceDSElement.addAttribute("maxActive", Integer.toString(ds.getMaxActive()));
        }
        if (ds.getMaxIdle() > 0) {
            newResourceDSElement.addAttribute("maxIdle", Long.toString(ds.getMaxIdle()));
        }
        this.saveDocumentInContextFile(doc);
    }

    public boolean deleteDataSource(TomcatDataSource ds) {
        Document doc = this.getDocument();
        this.findAndRemoveExistingDatasource(ds, doc);
        this.saveDocumentInContextFile(doc);
        return true;
    }

    private Document getDocument() {
        Document doc;
        if (this.contextFile.exists()) {
            SAXReader reader = new SAXReader();
            try {
                doc = reader.read(this.contextFile.get());
            }
            catch (RuntimeIOException e) {
                throw new RuntimeIOException("Unable to parse existing context xml file " + this.contextFile.getName(), (Throwable)e);
            }
            catch (DocumentException e) {
                throw new RuntimeIOException("Unable to parse existing context xml file " + this.contextFile.getName(), (Throwable)e);
            }
        } else {
            doc = DocumentHelper.createDocument();
        }
        return doc;
    }

    private void findAndRemoveExistingDatasource(TomcatDataSource ds, Document doc) {
        List resourceTypeList = doc.selectNodes("//Context/Resource/@type");
        for (Attribute type : resourceTypeList) {
            Element resource;
            Attribute name;
            String nameValue;
            String value = type.getValue();
            if (!value.equalsIgnoreCase("javax.sql.DataSource") || !(nameValue = (name = (Attribute)(resource = type.getParent()).selectSingleNode("@name")).getValue()).equals(ds.getJndiName())) continue;
            Element parent = resource.getParent();
            parent.remove(resource);
        }
    }

    private void findAndRemoveExistingDocBase(Document doc) {
        Attribute docBaseAttr = (Attribute)doc.selectSingleNode("//Context/@docBase");
        if (docBaseAttr != null) {
            docBaseAttr.getParent().remove(docBaseAttr);
        }
    }

    private void saveDocumentInContextFile(Document doc) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter);
        try {
            xmlWriter.write(doc);
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Unable to add or update Tomcat context xml file " + this.contextFile.getName(), (Throwable)e);
        }
        HostFileUtils.putStringToHostFile((String)stringWriter.toString(), (HostFile)this.contextFile);
    }

    private Element getOrCreateContext(Document doc) {
        Element contextElement = doc.selectSingleNode("//Context") == null ? doc.addElement("Context") : (Element)doc.selectSingleNode("Context");
        return contextElement;
    }
}

