package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;

@SuppressWarnings("serial")
public class TomcatWaitStep implements Step {

	public String getDescription() {
		return "Wait " + TomcatServer.DEPLOYMENT_COMPLETION_WAIT_TIME_MILLIS + "ms for Tomcat server to complete the step";
	}

	public boolean execute(StepExecutionContext ctx) {
		ctx.logOutput("Waiting " + TomcatServer.DEPLOYMENT_COMPLETION_WAIT_TIME_MILLIS + "ms for Tomcat server to complete the step");
		try {
			Thread.sleep(TomcatServer.DEPLOYMENT_COMPLETION_WAIT_TIME_MILLIS);
		} catch (InterruptedException ignored) {
		}
		return true;
	}

}
