package com.xebialabs.deployit.plugin.tomcat.step;

import java.io.IOException;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.TomcatManagerAppUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;

@SuppressWarnings("serial")
public class TomcatHttpBasedDeployApplicationStep extends TomcatDeploymentStepBase {

	private War war;

	public TomcatHttpBasedDeployApplicationStep(TomcatServer target, War war) {
		this(target, war, "");
	}

	public TomcatHttpBasedDeployApplicationStep(TomcatServer target, War war, String contextRoot) {
		super(target, war, contextRoot);
		this.war = war;
		setDescription("Deploy WAR file " + war + " to Tomcat server " + server + " using manager application");
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = server.connectToAdminHost();
		HostFile targetTmpFile;
		try {
			HostSession lhs = HostSessionFactory.getHostSession(Host.getLocalHost());
			try {
				HostFile sourceFile = lhs.getFile(artifact.getLocation());

				String artifactTargetFileName = getArtifactTargetFileName();

				targetTmpFile = rhs.getTempFile(artifactTargetFileName);
				ctx.logOutput("Copying application artifact to " + targetTmpFile.getPath() + " on " + server.getHost());
				HostFileUtils.copyFile(sourceFile, targetTmpFile);

				HostFile deployedWarFile = rhs.getFile(getDeployedArtifactPath());
				HostFileUtils.copyFile(targetTmpFile, deployedWarFile);

				String deployedWarPath;

				TomcatManagerAppUtils managerAppUtils = new TomcatManagerAppUtils(server);
				ctx.logOutput("Deploying " + getArtifactTargetFileName() + " using manager app url "
						+ managerAppUtils.getBaseUrl());

				if (isContextSet()) {
					// create the context file
					HostFile contextFile = rhs.getFile(getContextFilePathOnServer());
					TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(contextFile);
					contextFileUtils.addOrUpdateContextPath(server.getAppBase() + server.getHost().getFileSeparator()
							+ artifactTargetFileName);
					deployedWarPath = deployedWarFile.getPath();
				} else {
					deployedWarPath = targetTmpFile.getPath();
				}

				String contextRootPath = isContextSet()? contextRoot : artifact.getName();
				String deploymentResult = managerAppUtils.deploy(contextRootPath, deployedWarPath);
				ctx.logOutput(deploymentResult);

				if (deploymentResult.startsWith("OK")) {
					ctx.logOutput("Done.");
					return true;
				}

			} catch (IOException e) {
				ctx.logError(e.getMessage());
			} finally {
				lhs.close();
			}
		} finally {
			rhs.close();
		}
		return false;
	}

}
