package com.xebialabs.deployit.plugin.tomcat.mapper;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.artifact.mapping.WarMapping;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.mapper.Pair;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatDataSource;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.step.CreateTomcatDataSourceStep;
import com.xebialabs.deployit.plugin.tomcat.step.DestroyTomcatDataSourceStep;

public class DatasourceToTomcatServerMapper extends MappingAgnosticStepGeneratingMapper<TomcatDataSource, TomcatServer> {

	private Mapper<War, WarMapping, TomcatServer>[] tomcatServerMappers;

	public DatasourceToTomcatServerMapper(Change<Deployment> change,
			Mapper<War, WarMapping, TomcatServer>... tomcatServerMappers) {
		super(change);
		this.tomcatServerMappers = tomcatServerMappers;
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(TomcatDataSource newMappingSource,
			TomcatServer newMappingTarget, List<Step> steps) {

		Set<WarMapping> addedAndModifiedWarMappings = getAddedAndModifiedWarMappings();

		for (WarMapping warMapping : addedAndModifiedWarMappings) {
			if (warMapping.getTarget().equals(newMappingTarget)) {
				if (!StringUtils.isBlank(warMapping.getContextRoot())) {
					steps.add(new CreateTomcatDataSourceStep(newMappingTarget, newMappingSource, warMapping
							.getContextRoot()));
				} else {
					throw new ResolutionException("No war mapping with a set context root was found for "
							+ warMapping.getSource());
				}
			}

		}
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(TomcatDataSource oldMappingSource,
			TomcatServer oldMappingTarget, List<Step> steps) {

		Set<WarMapping> deletedAndModifiedMappings = getdeletedAndModifiedWarMappings();

		for (WarMapping warMapping : deletedAndModifiedMappings) {
			if (warMapping.getTarget().equals(oldMappingTarget)) {
				if (!StringUtils.isBlank(warMapping.getContextRoot())) {
					steps.add(new DestroyTomcatDataSourceStep(oldMappingTarget, oldMappingSource, warMapping
							.getContextRoot()));
				} else {
					throw new ResolutionException("No war mapping with a set context root was found for "
							+ warMapping.getSource());
				}
			}

		}
	}

	private Set<WarMapping> getdeletedAndModifiedWarMappings() {
		Set<WarMapping> warMappings = new HashSet<WarMapping>();
		for (Mapper<War, WarMapping, TomcatServer> mapper : tomcatServerMappers) {
			warMappings.addAll(mapper.getOldMappings());
//			for (Pair<WarMapping, WarMapping> pair : mapper.getModifiedMappings()) {
//				warMappings.add(pair.getFirst());
//			}
		}
		return warMappings;
	}

	private Set<WarMapping> getAddedAndModifiedWarMappings() {
		Set<WarMapping> warMappings = new HashSet<WarMapping>();
		for (Mapper<War, WarMapping, TomcatServer> mapper : tomcatServerMappers) {
			warMappings.addAll(mapper.getNewMappings());
//			for (Pair<WarMapping, WarMapping> pair : mapper.getModifiedMappings()) {
//				warMappings.add(pair.getSecond());
//			}
		}
		return warMappings;
	}
}
