package com.xebialabs.deployit.plugin.tomcat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;

public class TomcatManagerAppUtils {

	private TomcatServer server;
	private String baseUrl;

	public TomcatManagerAppUtils(TomcatServer server) {
		this.server = server;
		this.baseUrl = server.getAccessMethod().getValue() + "://" + server.getHost().getAddress() + ":" + server.getPort() + "/" + server.getManagerAppContext();
	}

	/**
	 * 
	 * @param war
	 * @param warLocation
	 * @return
	 * @throws IOException
	 */
	public String deploy(String contextRoot, String warLocation) throws IOException {
		String url = baseUrl + "/deploy?path=/" + contextRoot + "&war=file:"+warLocation;
		return executeManagerAppCommand(url);
	}

	/**
	 * 
	 * @param war
	 * @param warLocation
	 * @return
	 * @throws IOException
	 */
	public boolean checkApplicationIsDeployed(String applicationName) {
		String url = baseUrl + "/list";
		String execetionResultStr;
		try {
			execetionResultStr = executeManagerAppCommand(url);
		} catch (HttpException e) {
			throw new RuntimeException("error found in calling manager URL " + url, e);
		} catch (IOException e) {
			throw new RuntimeException("error found in calling manager URL " + url, e);
		}
		return execetionResultStr.contains(applicationName);
	}
	
	/**
	 * 
	 * @param war
	 * @return
	 * @throws IOException
	 */
	public String undeploy(String contextRoot) throws IOException{
		String url = baseUrl + "/undeploy?path=/" + contextRoot;
		return executeManagerAppCommand(url);
	}
	
	private String executeManagerAppCommand(String url) throws IOException, HttpException {
		HttpMethod method = invokeClientWithUrl(url);
		return getResponseFromUrl(method);
	}

	private HttpMethod invokeClientWithUrl(String url) throws IOException, HttpException {
		HttpClient client = new HttpClient();
		if (StringUtils.isNotBlank(server.getManagerUsername()) && StringUtils.isNotBlank(server.getManagerPassword())) {
			Credentials defaultcreds = new UsernamePasswordCredentials(server.getManagerUsername(), server
					.getManagerPassword());
			client.getState().setCredentials(AuthScope.ANY, defaultcreds);
		}

		GetMethod method = new GetMethod(url);
		method.setDoAuthentication(true);
		int status = 0;
		status = client.executeMethod(method);

		if (status != HttpStatus.SC_OK) {
			throw new RuntimeException("Can't access the manager app from URL " + url + ". HTTP status: " + status);
		}
		return method;
	}

	private String getResponseFromUrl(HttpMethod method) throws IOException {
		BufferedReader reader;
		reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
		StringBuffer responseBody = new StringBuffer();

		String readLine;
		while (!StringUtils.isBlank((readLine = reader.readLine()))) {
			responseBody.append(readLine + "\n");
		}
		reader.close();

		method.releaseConnection();
		return responseBody.toString();
	}

	public String getBaseUrl() {
		return baseUrl;
	}
}
