/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support.deployment.tester;

import com.google.common.collect.Maps;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeployedItemTester {
    String SUCCESSFULL = "OK";
    String FAILED = "FAILED";
    Map<String, String> testParams;

    public final String getTestName() {
        return this.testParams.get("testName");
    }

    public abstract boolean testDeployedItem();

    public DeployedItemTester(Map<String, String> testParams) {
        this.testParams = testParams;
    }

    public static Map<String, String> getTestResults(String url) {
        HashMap testResults = Maps.newHashMap();
        String webpageContent = DeployedItemTester.getWebPageContent(url);
        DeployedItemTester.populateTestResults(webpageContent, testResults);
        return testResults;
    }

    private static void populateTestResults(String content, Map<String, String> testResults) {
        Pattern pattern1 = Pattern.compile("[-_/.\\w]+=\\w+", 8);
        Pattern pattern2 = Pattern.compile("([-_/.\\w]+)=(\\w+)");
        Matcher matcher = pattern1.matcher(content);
        while (matcher.find()) {
            String group = matcher.group();
            Matcher matcher2 = pattern2.matcher(group);
            if (!matcher2.find()) continue;
            testResults.put(matcher2.group(1), matcher2.group(2));
        }
    }

    private static String getWebPageContent(String url) {
        String content = null;
        URLConnection connection = null;
        try {
            connection = new URL(url).openConnection();
            Scanner scanner = new Scanner(connection.getInputStream());
            scanner.useDelimiter("\\Z");
            content = scanner.next();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return content;
    }
}

