/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.test.support.onthefly;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;

/**
 * Constructs a JAR for testing, accepting multiple {@link Resource resources} as entries
 * and writing the actual JAR file to a temporary directory. Example:
 * 
 * <pre>
 * JarOnTheFly jarOnTheFly = new JarOnTheFly();
 * jarOnTheFly.addFile("foo", someFile);
 * jarOnTheFly.addFile("bar", someResource);
 * ...
 * File jar = jarOnTheFly.writeToTemporaryFile("myJar", ".jar"); // something like myJarXX.jar
 * </pre>
 * 
 * See also &quot;<a href="http://blog.xebia.com/2009/12/14/middleware-integration-testing-with-junit-maven-and-vmware-part-2/">
 * Middleware integration testing with JUnit, Maven and VMware: part 2</a>&quot;.
 */
public class JarOnTheFly {

	private Map<String, Resource> files = new HashMap<String, Resource>();

	public void addFile(String filename, Resource resource) {
		files.put(filename, resource);
	}

	public void write(File jarFile) throws IOException {
		FileOutputStream jarFileOut = new FileOutputStream(jarFile);
		try {
			JarOutputStream jarOut = new JarOutputStream(jarFileOut);
			try {
				for (Map.Entry<String, Resource> eachFile : files.entrySet()) {
					String filename = eachFile.getKey();
					Resource resource = eachFile.getValue();
					jarOut.putNextEntry(new JarEntry(filename));
					InputStream resourceIn = resource.getInputStream();
					try {
						IOUtils.copy(resourceIn, jarOut);
					} finally {
						IOUtils.closeQuietly(resourceIn);
					}
					jarOut.closeEntry();
				}
			} finally {
				IOUtils.closeQuietly(jarOut);
			}
		} finally {
			IOUtils.closeQuietly(jarFileOut);
		}
	}

	protected File writeToTemporaryFile(String prefix, String suffix) throws IOException {
		File tempJarFile = File.createTempFile(prefix, suffix);
		write(tempJarFile);
		return tempJarFile;
	}
}
