/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.test;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemRoot;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.test.DummyWasCluster;
import com.xebialabs.deployit.plugin.test.DummyWasManagedServer;
import com.xebialabs.deployit.plugin.test.DummyWasNodeAgent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@ConfigurationItem(root=ConfigurationItemRoot.INFRASTRUCTURE, discoverable=true)
public class DummyWasDeploymentManager
extends BaseConfigurationItem
implements Discoverable<DummyWasDeploymentManager> {
    public static final String DISCOVERED_DEPLOYMENT_MANAGER_NAME = "dmgr1";
    public static final Object DISCOVERED_NODE_AGENT_NAME = "nodeagent1";
    public static final String DISCOVERED_NODE_AGENT_ID_PREFIX = "Node with name of ";
    public static final String DISCOVERED_NODE_AGENT_KEY = "Nodes";
    public static final String DISCOVERED_SERVER_NAME = "server1";
    public static final String DISCOVERED_SERVER_ID_PREFIX = "Server with name of ";
    public static final String DISCOVERED_SERVER_KEY = "Servers";
    public static final String DISCOVERED_CLUSTER_NAME = "cluster1";
    public static final String DISCOVERED_CLUSTER_ID_PREFIX = "Cluster with the name of ";
    public static final String DISCOVERED_CLUSTER_KEY = "Clusters";
    @ConfigurationItemProperty
    private String name;
    @ConfigurationItemProperty
    private Host host;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public DummyWasDeploymentManager discover(Map<String, Object> info, ChangePlan cp) {
        ArrayList steps = Lists.newArrayList();
        steps.add(new SetNameStep());
        steps.add(new FindChildrenStep());
        cp.addSteps((List)steps);
        cp.execute(info);
        return this;
    }

    public DummyWasDeploymentManager discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
        String discoveredNodeAgentName = (String)info.get(DISCOVERED_NODE_AGENT_KEY);
        DummyWasNodeAgent discoveredNodeAgent = new DummyWasNodeAgent();
        discoveredNodeAgent.setName(discoveredNodeAgentName);
        discoveredNodeAgent.setDeploymentManager(this);
        discoveredNodeAgent.setLabel(DISCOVERED_NODE_AGENT_ID_PREFIX + discoveredNodeAgentName);
        info.put("1", Lists.newArrayList((Object[])new DummyWasNodeAgent[]{discoveredNodeAgent}));
        String discoveredServerName = (String)info.get(DISCOVERED_SERVER_KEY);
        DummyWasManagedServer discoveredServer = new DummyWasManagedServer();
        discoveredServer.setName(DISCOVERED_SERVER_NAME);
        discoveredServer.setNodeAgent(discoveredNodeAgent);
        discoveredServer.setLabel(DISCOVERED_SERVER_ID_PREFIX + discoveredServerName);
        info.put("2", Lists.newArrayList((Object[])new DummyWasManagedServer[]{discoveredServer}));
        String discoveredClusterName = (String)info.get(DISCOVERED_CLUSTER_KEY);
        DummyWasCluster discoveredCluster = new DummyWasCluster();
        discoveredCluster.setDeploymentManager(this);
        discoveredCluster.setServers(Collections.singleton(discoveredServer));
        discoveredCluster.setLabel(DISCOVERED_CLUSTER_ID_PREFIX + discoveredClusterName);
        info.put("3", Lists.newArrayList((Object[])new DummyWasCluster[]{discoveredCluster}));
        return this;
    }

    private class FindChildrenStep
    implements Step {
        private FindChildrenStep() {
        }

        public String getDescription() {
            return this.getClass().getName();
        }

        public boolean execute(StepExecutionContext ctx) {
            ctx.setAttribute(DummyWasDeploymentManager.DISCOVERED_NODE_AGENT_KEY, DISCOVERED_NODE_AGENT_NAME);
            ctx.setAttribute(DummyWasDeploymentManager.DISCOVERED_SERVER_KEY, (Object)DummyWasDeploymentManager.DISCOVERED_SERVER_NAME);
            ctx.setAttribute(DummyWasDeploymentManager.DISCOVERED_CLUSTER_KEY, (Object)DummyWasDeploymentManager.DISCOVERED_CLUSTER_NAME);
            return true;
        }
    }

    private class SetNameStep
    implements Step {
        private SetNameStep() {
        }

        public String getDescription() {
            return this.getClass().getName();
        }

        public boolean execute(StepExecutionContext ctx) {
            DummyWasDeploymentManager.this.setName(DummyWasDeploymentManager.DISCOVERED_DEPLOYMENT_MANAGER_NAME);
            return true;
        }
    }
}

