package datasets.ciexplorer

import com.xebialabs.deployit.repository.RepositoryServiceHolder
import com.xebialabs.deployit.rest.test.api.DataSet
import ai.digital.deploy.tasker.common.TaskType
import dsl.TaskState._
import dsl.{CiUtils, EarUtils, TaskUtils}
import org.joda.time.DateTime

object CiExplorerSet2 extends DataSet with TaskUtils with CiUtils with EarUtils {
  override def name() = "CiExplorer2"

  override def generateSet(args_unused: List[String] = List()): Unit = {
    val repository = RepositoryServiceHolder.getRepositoryService
    val appIds = (List("LongRunningApp_Report", "TestApp_Report") ++ (0 to 50).map(i => s"TestApp${i}_Report")).map("/Applications/" + _)
    val envIds = List("Env1_Report", "Env2_Report", "TestDirEnv_Report/Env2_Report").map("/Environments/" + _)
    val apps = readCisAsMap(appIds, repository)
    val envs = readCisAsMap(envIds, repository)

    // Create 50 successful deployments not later than 90 days
    val successfulStartDate = new DateTime()
    for (i <- 0 to 50) {
      createTaskWithDependencies(apps(s"TestApp${i}_Report"), "1.0", envs("TestDirEnv_Report/Env2_Report"), successfulStartDate.minusDays(i), 10, SUCCESSFUL, TaskType.INITIAL, Map())
      createTaskWithDependencies(apps(s"TestApp${i}_Report"), "1.0", envs("TestDirEnv_Report/Env2_Report"), successfulStartDate.minusDays(i), 5, ABORTED, TaskType.INITIAL, Map())
      createTaskWithDependencies(apps(s"TestApp${i}_Report"), "1.0", envs("TestDirEnv_Report/Env2_Report"), successfulStartDate.minusDays(i), 5, FAILED, TaskType.ROLLBACK, Map())
      createTaskWithDependencies(apps(s"TestApp${i}_Report"), "1.0", envs("TestDirEnv_Report/Env2_Report"), successfulStartDate.minusDays(i), 5, FAILED, TaskType.INITIAL, Map())
    }

    //Create more then 100 tasks in a specific time range to test pagination
    val startDate = new DateTime(2005, 1, 1, 12, 0)
    for (i <- 0 to 121)
      createTaskWithDependencies(apps("TestApp_Report"), "1.0", envs("Env1_Report"), startDate.plusDays(i), 10, SUCCESSFUL, TaskType.INITIAL, Map())
  }
}
