package com.xebialabs.deployit.plugin;

import java.util.concurrent.atomic.AtomicReference;

import com.xebialabs.deployit.repository.placeholders.ResolvedPlaceholderRepository;
import com.xebialabs.deployit.spring.BeanWrapper;
import com.xebialabs.deployit.task.archive.TaskArchiveStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.task.archive.TaskArchive;

@Component
public class TestServiceHolder {

    private static final AtomicReference<ImporterService> importerService = new AtomicReference<>();
    private static final AtomicReference<UserService> userService = new AtomicReference<>();
    private static final AtomicReference<TaskArchiveStore> taskArchiveStore = new AtomicReference<>();
    private static final AtomicReference<WorkDirFactory> workDirFactory = new AtomicReference<>();
    private static final AtomicReference<RoleService> roleService = new AtomicReference<>();
    private static final AtomicReference<PermissionEditor> permissionEditor = new AtomicReference<>();
    private static final AtomicReference<ResolvedPlaceholderRepository> resolvedPlaceholderRepository = new AtomicReference<>();
    private static BeanWrapper<TaskExecutionEngine> wrappedEngine = null;

    @Autowired
    public TestServiceHolder(ImporterService importerService, UserService userService, BeanWrapper<TaskExecutionEngine> engine,
                             TaskArchiveStore taskArchive, WorkDirFactory workDirFactory, RoleService roleService,
                             PermissionEditor permissionEditor, ResolvedPlaceholderRepository resolvedPlaceholderRepository) {
        TestServiceHolder.importerService.set(importerService);
        TestServiceHolder.userService.set(userService);
        TestServiceHolder.wrappedEngine = engine;
        TestServiceHolder.taskArchiveStore.set(taskArchive);
        TestServiceHolder.workDirFactory.set(workDirFactory);
        TestServiceHolder.roleService.set(roleService);
        TestServiceHolder.permissionEditor.set(permissionEditor);
        TestServiceHolder.resolvedPlaceholderRepository.set(resolvedPlaceholderRepository);
    }

    public static ImporterService getImporterService() {
        return TestServiceHolder.importerService.get();
    }

    public static UserService getUserService() {
        return TestServiceHolder.userService.get();
    }

    public static TaskExecutionEngine getExecutionEngine() {
        return wrappedEngine.get();
    }

    public static TaskArchiveStore getTaskArchiveStore() {
        return TestServiceHolder.taskArchiveStore.get();
    }

    public static WorkDirFactory getWorkDirFactory() {
        return TestServiceHolder.workDirFactory.get();
    }

    public static RoleService getRoleService() {
        return TestServiceHolder.roleService.get();
    }

    public static PermissionEditor getPermissionEditor() {
        return TestServiceHolder.permissionEditor.get();
    }

    public static ResolvedPlaceholderRepository getResolvedPlaceholderRepository() {
        return resolvedPlaceholderRepository.get();
    }
}
