package dsl

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry
import com.xebialabs.deployit.plugin.api.udm.{Application, _}
import com.xebialabs.deployit.plugin.test.school.ClassRoom
import com.xebialabs.deployit.plugin.test.v3._
import com.xebialabs.deployit.repository.ChangeSet
import com.xebialabs.deployit.repository.core.Directory

import java.util.{Map => JMap}
import scala.jdk.CollectionConverters._

class Creator(val changeSet: ChangeSet) {
  def ci[A <: ConfigurationItem](id: String, t: A)(c: A => Unit): A = {
    t.setId(id)
    c.apply(t)
    changeSet.getCreateCis.add(t)
    t
  }

  def pipeline(id: String): ConfigurationItem = {
    val p: ConfigurationItem = DescriptorRegistry.getDescriptor("release.DeploymentPipeline").newInstance("Configuration/" + id)
    changeSet.getCreateCis.add(p)
    p
  }

  def template(id: String, desc: String, amount: Int): ConfigurationItem = {
    val p: ConfigurationItem = DescriptorRegistry.getDescriptor("test-v3.DummyEnvironmentTemplate").newInstance("Configuration/" + id)
    p.setProperty("description", desc)
    p.setProperty("amount", amount)
    changeSet.getCreateCis.add(p)
    p
  }

  def environment(id: String)(members: List[_ <: Container]): Environment = {
    env(id) {
      e =>
        members.foreach(e.addMember)
    }
  }

  def deploymentPackage(id: String, app: Application, deps: Map[String, String] = Map())(deployables: DeploymentPackage => List[_ <: Deployable]): DeploymentPackage = {
    val dp: DeploymentPackage = new DeploymentPackage()
    dp.setId(app.getId + "/" + id)
    dp.setApplicationDependencies(deps.asJava)
    changeSet.getCreateCis.add(dp)
    deployables.apply(dp).foreach(dp.addDeployable)
    dp
  }

  def env(id: String): (Environment => Unit) => Environment = {
    ci("Environments/" + id, new Environment())
  }

  def server(id: String): (DummyJeeServer => Unit) => DummyJeeServer = {
    ci("Infrastructure/" + id, new DummyJeeServer())
  }

  def classroom(id: String): (ClassRoom => Unit) => ClassRoom = {
    ci("Infrastructure/" + id, new ClassRoom())
  }

  def host(id: String): (DummyHost => Unit) => DummyHost = {
    ci("Infrastructure/" + id, new DummyHost())
  }

  def application(id: String): Application = {
    ci("Applications/" + id, new Application)(_ => ())
  }

  def directory(fullId: String): Directory = {
    ci(fullId, new Directory)(_ => ())
  }

  def dictionary(name: String, entries: JMap[String, String]): Dictionary = {
    ci("Environments/" + name, new Dictionary) {
      dictionary => dictionary.setEntries(entries)
    }
  }

  def ear(id: String, dp: DeploymentPackage): (DummyEar => Unit) => DummyEar = {
    ci(dp.getId + "/" + id, new DummyEar)
  }

  def earWithProperties(id: String, dp: DeploymentPackage): (DummyEarWithAllProperties => Unit) => DummyEarWithAllProperties = {
    ci(dp.getId + "/" + id, new DummyEarWithAllProperties)
  }

  def configurationFile(id: String, dp: DeploymentPackage): (ConfigurationFiles => Unit) => ConfigurationFiles = {
    ci(dp.getId + "/" + id, new ConfigurationFiles)
  }

  def portal(id: String, dp: DeploymentPackage): (PortalWar => Unit) => PortalWar = {
    ci(dp.getId + "/" + id, new PortalWar)
  }

  def portlet(id: String, pw: PortalWar): (Portlet => Unit) => Portlet = {
    ci(pw.getId + "/" + id, new Portlet)
  }

  def settings(id: String, pl: Portlet): PortletSettings = {
    ci(pl.getId + "/" + id, new PortletSettings)(_ => ())
  }

  def attributes(id: String, pl: Portlet): PortletAttributes = {
    ci(pl.getId + "/" + id, new PortletAttributes)(_ => ())
  }

  def cleanUp(): Unit = {
  }
}
