package datasets

import com.xebialabs.deployit.rest.test.api.DataSet
import dsl.{EarUtils, EnvironmentUtils}

object ExporterPerformanceSet extends DataSet with EarUtils with EnvironmentUtils {

  def name() = "ExporterPerformanceSet"

  def generateSet(args_unused: List[String]): Unit = {
    create { c =>
      val count = 30000
      createPackageWithDummyEar(c = c, appName = "PERFORM_APP_100000_PACK", nrPackages = count, packageSize = 2, earName = "dummy.ear")
      createEnvsWithServers(c, nrEnvs = 1, nrServers = count, name = "PERFORM_ENV_1SER_100000_Steps", kbLog = 1, nrSteps = 100, numberOfBlocks = 1)
    }
  }
}
