package dsl

import com.xebialabs.deployit.plugin.api.udm.{Container, Environment}
import com.xebialabs.deployit.plugin.test.v3.DummyJeeServer

trait EnvironmentUtils {

  def createEnvironments(c: Creator): Unit = {
    createSchoolEnvironment(c)
    createEnvsWithServersAndHost(c = c, nrEnvs = 10, nrServers = 1, name = "host", kbLog = 1, nrSteps = 1)
    createEnvsWithServers(c = c, nrEnvs = 10, nrServers = 1, name = "tiny", kbLog = 1, nrSteps = 1)
    createEnvsWithServers(c = c, nrEnvs = 25, nrServers = 2, name = "small", kbLog = 1, nrSteps = 5)
    createEnvsWithServers(c = c, nrEnvs = 25, nrServers = 20, name = "large", kbLog = 1, nrSteps = 20)
    createEnvsWithServers(c = c, nrEnvs = 10, nrServers = 1, name = "new", kbLog = 1, nrSteps = 1)
    createEnvsWithServers(c = c, nrEnvs = 3, nrServers = 1, name = "slow", kbLog = 1, nrSteps = 1, delayMillis = 2000)
    createEnvsWithServers(c = c, nrEnvs = 3, nrServers = 3, name = "parallel", kbLog = 1, nrSteps = 2, delayMillis = 500,
      serversCallback = (s: DummyJeeServer) => s.setProperty[Int]("deploymentGroup", if (s.getName.endsWith("2")) 2 else 1)
    )
    createEnvsWithServers(c = c, nrEnvs = 3, nrServers = 3, name = "staging", kbLog = 1, nrSteps = 2, delayMillis = 500,
      serversCallback = (s: DummyJeeServer) => s.setProperty[String]("stagingDirectoryPath", "/tmp")
    )
  }

  def createSchoolEnvironment(c: Creator): Environment = {
    c.environment("0school") {
      List(c.classroom("classroom")(_ => {}))
    }
  }

  def createEnvsWithServers(c: Creator, nrEnvs: Int, nrServers: Int, name: String, kbLog: Int, nrSteps: Int,
                            delayMillis: Int = 100, numberOfBlocks: Int = 10, serversCallback: DummyJeeServer => Unit = _ => ()): Unit = {
    createEnvs(c, name, nrEnvs, createServers(c, nrServers, name, kbLog, nrSteps, delayMillis, numberOfBlocks, serversCallback))
  }

  def createEnvsWithServersAndHost(c: Creator, nrEnvs: Int, nrServers: Int, name: String, kbLog: Int, nrSteps: Int, delayMillis: Int = 100): Unit = {
    val servers = createServers(c, nrServers, name, kbLog, nrSteps, delayMillis)
    val host = List(c.host("Host-with-" + name + "Server") { h =>
      h.setOs("Unix")
      h.setAddress("localhost")
      h.setUsername("admin")
      h.setPassword("admin")
      h.setAccessMethod("FTP")
    })
    createEnvs(c, name, nrEnvs, servers.concat(host))
  }

  def createServers(c: Creator, nrServers: Int, name: String, kbLog: Int, nrSteps: Int, delayMillis: Int = 100,
                    numberOfBlocks: Int = 10, serversCallback: DummyJeeServer => Unit = s => ()): List[_ <: Container] = {
    (for (i <- 0 until nrServers) yield c.server(name + "Server" + i) { s =>
      s.setAmountOfKBLogFiles(kbLog)
      s.setNumberOfSteps(nrSteps)
      s.setStepDelayTimeInMilliSeconds(delayMillis)
      s.setNumberOfCreateStepBlocks(numberOfBlocks)
      s.setHostName("dummy.host")
      serversCallback(s)
    }).toList
  }

  def createEnvs(c: Creator, name: String, nrEnvs: Int, containers: List[_ <: Container]): Unit = {
    for (i <- 0 until nrEnvs) yield c.environment(i + name + "Env" + i) {
      containers
    }
  }
}
