/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class LicenseExpiryCheckFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(LicenseExpiryCheckFilter.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private XldConfig xldConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.trace("Added LicenseExpiryCheckFilter to the mix.");
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)this);
    }

    public void setLicenseService(LicenseService licenseService) {
        Checks.checkNotNull((Object)licenseService, (String)"LicenseExpiryCheckFilter: Could not find license check service");
        this.licenseService = licenseService;
    }

    public void setXldConfig(XldConfig xldConfig) {
        Checks.checkNotNull((Object)xldConfig, (String)"LicenseExpiryCheckFilter: Could not find license check service");
        this.xldConfig = xldConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean licenseExpiringSoon;
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return;
        }
        License license = this.licenseService.getLicense();
        int daysToShowWarning = this.xldConfig.licenseConfig().daysToShowWarning();
        Period validPeriod = this.licenseService.getValidPeriod();
        Authentication authentication = Permissions.getAuthentication();
        boolean hasAuthentication = null != authentication;
        boolean bl = licenseExpiringSoon = validPeriod.getDays() < daysToShowWarning;
        if (hasAuthentication && PermissionHelper.isCurrentUserAdmin() && licenseExpiringSoon) {
            ((HttpServletResponse)response).setHeader("LICENSE-EXPIRY-DATE", license.getStringValue(LicenseProperty.EXPIRES_AFTER));
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

