/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.Server;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.core.config.XldSystemConfig;
import com.xebialabs.deployit.log.LogbackHelper;
import com.xebialabs.deployit.plugin.satellite.SatelliteCommunicatorSystem;
import com.xebialabs.deployit.setup.Setup;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.platform.script.jython.EngineInstance;
import com.xebialabs.plugin.Xlp;
import com.xebialabs.xlplatform.jmx.JMXAgent;
import com.xebialabs.xlplatform.jmx.JMXSettings;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import javax.crypto.SecretKey;
import kamon.Kamon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitBootstrapper {
    static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    static final File DEFAULT_CONFIGURATION_FILE = new File("conf", "deployit.conf");
    private static final File EXT_FOLDER = new File("ext");
    private static final File XL_PLUGINS_FOLDER = new File("plugins");
    private static final File XL_HOTFIX_PLUGINS_FOLDER = new File("hotfix/plugins");
    private static final String XL_PLUGIN_EXTENSION = "xldp";
    private final ServerLaunchOptions launchOptions;
    private final ServerConfigFile serverConfigFile;
    private boolean isConfigAndPasswordInitDone = false;
    private static final Logger logger = LoggerFactory.getLogger(DeployitBootstrapper.class);

    public static void main(String[] args) {
        LogbackHelper.disableConsoleLoggerIfNeeded((String)"STDOUT");
        LogbackHelper.enableJavaUtilLoggingBridge();
        DeployitBootstrapper.setUpDefaultLogLevels();
        XL_HOTFIX_PLUGINS_FOLDER.mkdirs();
        Xlp.init((String)XL_PLUGIN_EXTENSION, Arrays.asList(XL_HOTFIX_PLUGINS_FOLDER, XL_PLUGINS_FOLDER), Arrays.asList(EXT_FOLDER));
        ServerLaunchOptions launchOptions = ServerLaunchOptions.parseCommandLine((String[])args);
        if (launchOptions == null) {
            return;
        }
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
        logger.info("XL Deploy version {} (built at {})", (Object)releaseInfo.getVersion(), (Object)releaseInfo.getDate());
        logger.info("(c) 2008-{} XebiaLabs", (Object)new SimpleDateFormat("yyyy").format(new Date()));
        DeployitBootstrapper.initialiseJython();
        ServerConfigFile serverConfigFile = new ServerConfigFile(DEFAULT_CONFIGURATION_FILE);
        try {
            new DeployitBootstrapper(launchOptions, serverConfigFile).start();
            DeployitBootstrapper.setUpTrustStorePassword();
        }
        catch (Exception e) {
            logger.error("Could not start {}", (Object)"XL Deploy", (Object)e);
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    static void setUpTrustStorePassword() {
        if (Objects.isNull(System.getProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD)) && Objects.nonNull(ServerConfiguration.getInstance()) && Objects.nonNull(ServerConfiguration.getInstance().getTrustStorePassword())) {
            System.setProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD, ServerConfiguration.getInstance().getTrustStorePassword());
        }
    }

    private static void setUpDefaultLogLevels() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.getLogger("org.eclipse.jetty.server.session").setLevel(Level.WARN);
    }

    public DeployitBootstrapper(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile) {
        this.launchOptions = launchOptions;
        this.serverConfigFile = serverConfigFile;
    }

    private void start() {
        if (this.launchOptions.isDoSetup()) {
            DeployitBootstrapper.startSetup(this.launchOptions, this.serverConfigFile);
            if (!this.isConfigAndPasswordInitDone) {
                this.loadConfigAndInitPasswordEncryptionKey();
            }
        } else {
            if (!this.serverConfigFile.exists()) {
                logger.warn("Configuration not found...");
                DeployitBootstrapper.startSetup(this.launchOptions, this.serverConfigFile);
            } else if (this.launchOptions.isReinitialize()) {
                logger.warn("Not re-initializing as the -setup flag is missing.");
            }
            if (!this.isConfigAndPasswordInitDone) {
                this.loadConfigAndInitPasswordEncryptionKey();
            }
            DeployitBootstrapper.startServer(this.launchOptions, this.serverConfigFile);
        }
        this.initializeJMXAgent();
    }

    private void initializeJMXAgent() {
        Config config = SatelliteCommunicatorSystem.loadConfig((Config)ConfigFactory.parseResources((String)"system.conf"));
        JMXSettings jmxSettings = new JMXSettings(config);
        new JMXAgent().start(jmxSettings);
        if (jmxSettings.enabled()) {
            Kamon.start((Config)config.getConfig("xl.jmx").withOnlyPath("kamon").withFallback((ConfigMergeable)ConfigFactory.defaultReference()));
        }
    }

    private static void initialiseJython() {
        try {
            logger.info("Starting up Jython engine (might take a while)...");
            EngineInstance.jython().eval("True");
            logger.info("Jython engine loaded [" + EngineInstance.jython().getFactory().getEngineVersion() + "]");
        }
        catch (Exception e) {
            logger.warn("Exception while initialising jython engine", (Throwable)e);
        }
    }

    private static void startServer(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile) {
        logger.info("Starting server...");
        try {
            Server.start("XL Deploy Server", launchOptions, serverConfigFile);
        }
        catch (Throwable e) {
            logger.error("Fatal error starting server");
            logger.error(e.getMessage());
            System.exit(1);
        }
    }

    private static void startSetup(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile) {
        new Setup("XL Deploy Server", serverConfigFile, launchOptions).run();
    }

    ServerConfiguration loadConfigAndInitPasswordEncryptionKey() {
        ServerConfiguration config = this.serverConfigFile.loadConfig(false, false);
        String repositoryKeyStorePassword = this.launchOptions.getRepositoryKeystorePassword() != null ? this.launchOptions.getRepositoryKeystorePassword() : config.getRepositoryKeyStorePassword();
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            throw new RuntimeException("Could not load the encryption key. The server will not start.");
        }
        config.loadEncryptedPasswords();
        this.serverConfigFile.saveDirtyConfiguration(config);
        ServerConfiguration.setInstance((ServerConfiguration)config);
        this.isConfigAndPasswordInitDone = true;
        XldSystemConfig.init((ServerConfiguration)config);
        return config;
    }
}

