package com.xebialabs.deployit;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.xml.XStreamReaderWriter;

// PLEASE NOTE: Do not remove the implemented interface, it is needed by RestEasy, even though the ClosingExceptionMapper also implements it.
@Provider
@Component
public class DeployitExceptionMapper extends ClosingExceptionMapper<DeployitException> implements ExceptionMapper<DeployitException> {

    @Override
    public Response handleException(DeployitException exception) {
        logger.info("Intercepting DeployitException", exception);

        // Status code
        final HttpResponseCodeResult annotation = exception.getClass().getAnnotation(HttpResponseCodeResult.class);
        int status = 500;
        if (annotation != null) {
            status = annotation.statusCode();
        }

        // Headers
        final Response.ResponseBuilder builder = Response.status(status).type(MediaType.APPLICATION_XML);
        builder.header("X-Deployit-Exception", "true");
        builder.header("X-Exception-Type", exception.getClass().getName());

        // Body: entity or error messages
        if (exception.hasEntity()) {
            builder.header("X-Entity", "true");
            builder.entity(XStreamReaderWriter.getConfiguredXStream().toXML(exception.getEntity()));
        } else {
            builder.entity(Sanitizer.sanitize(Exceptions.getAllMessages(exception))).build();
        }

        final Response response = builder.build();
        logger.info("Returning response {}", response);
        return response;
    }

    private static final Logger logger = LoggerFactory.getLogger(DeployitExceptionMapper.class);

}
