package com.xebialabs.deployit;

import com.xebialabs.deployit.core.rest.resteasy.OpenJcrSessionDuringRequestInterceptor;
import com.xebialabs.deployit.io.TemporaryFiles;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.repository.NodeReaderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public abstract class ClosingExceptionMapper<E extends Exception> implements ExceptionMapper<E> {
	@Override
	public final Response toResponse(E exception) {
		try {
			return handleException(exception);
		} finally {
			logger.info("Closing JcrSession if needed.");
			if (JcrTemplateHolder.get().isLoggedIn()) {
				JcrTemplateHolder.get().logout();
				NodeReaderContext.get().release();
			}
			TemporaryFiles.clear();
			MDC.remove(OpenJcrSessionDuringRequestInterceptor.MDC_KEY_USERNAME);
		}
	}

	protected abstract Response handleException(E exception);

	private static final Logger logger = LoggerFactory.getLogger(ClosingExceptionMapper.class);
}
