/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.DeployitConfiguration;
import com.xebialabs.deployit.DeployitOptions;
import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.Server;
import com.xebialabs.deployit.setup.Setup;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitBootstrapper {
    private static final Logger logger = LoggerFactory.getLogger(DeployitBootstrapper.class);

    public static void main(String[] args) {
        DeployitOptions deployitOptions = DeployitOptions.parseCommandLine(args);
        if (deployitOptions == null) {
            return;
        }
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
        logger.info("Deployit version {} (built at {})", (Object)releaseInfo.getVersion(), (Object)releaseInfo.getDate());
        logger.info("(c) 2008-{} XebiaLabs", (Object)new SimpleDateFormat("yyyy").format(new Date()));
        if (deployitOptions.isDoSetup()) {
            DeployitBootstrapper.startSetup(deployitOptions);
        } else {
            if (!DeployitConfiguration.exists()) {
                logger.error("Configuration not found...");
                DeployitBootstrapper.startSetup(deployitOptions);
            } else if (deployitOptions.isReinitialize()) {
                logger.warn("Not re-initializing as the -setup flag is missing.");
            }
            DeployitBootstrapper.startServer(deployitOptions);
        }
    }

    private static void startServer(DeployitOptions deployitOptions) {
        logger.info("Starting server...");
        Server.start(deployitOptions);
    }

    private static void startSetup(DeployitOptions deployitOptions) {
        logger.info("Starting setup...");
        Setup.setup(deployitOptions);
    }
}

