package com.xebialabs.deployit;

import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

import java.io.PrintStream;

/**
 */
public class DeployitOptions {

	@Option(name="-setup", usage = "(Re-)run the setup for Deployit", required = false)
	private boolean doSetup = false;

	@Option(name="-reinitialize", usage = "Reinitialize the repository, only useful with -setup", required = false)
	private boolean reinitialize = false;

	@Option(name="-force", required = false)
	private boolean force;

    @Option(name="-test-mode", required = false)
    private boolean isTestModeEnabled;

	@Option(name = "-help", required = false, usage = "Prints this usage message")
	private boolean printUsage = false;
	
	public boolean isDoSetup() {
		return doSetup;
	}

	public void setDoSetup(final boolean doSetup) {
		this.doSetup = doSetup;
	}

	public boolean isReinitialize() {
		return reinitialize;
	}

	public void setReinitialize(final boolean reinitialize) {
		this.reinitialize = reinitialize;
	}

    public boolean isTestModeEnabled() {
        return isTestModeEnabled;
    }

    public void setTestModeEnabled(final boolean testModeEnabled) {
        isTestModeEnabled = testModeEnabled;
    }

	public boolean isForce() {
		return force;
	}

	public void setForce(boolean force) {
		this.force = force;
	}

	public boolean isPrintUsage() {
		return printUsage;
	}

	public void setPrintUsage(boolean printUsage) {
		this.printUsage = printUsage;
	}

	static DeployitOptions parseCommandLine(String[] args) {
		DeployitOptions options = new DeployitOptions();
		final CmdLineParser parser = new CmdLineParser(options);
		try {
			parser.parseArgument(args);
			if (options.isPrintUsage()) {
				printUsage(parser, System.out);
				return null;
			}
		} catch (CmdLineException e) {
			System.err.println(e.getMessage());
			printUsage(parser, System.err);
			return null;
		}
		return options;

	}

	private static void printUsage(CmdLineParser parser, PrintStream stream) {
		stream.println("java -cp deployit-server-<version>.jar [options...] com.xebialabs.deployit.Deployit arguments...");
		parser.printUsage(stream);
	}
}
