/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCodeManglingFilter
implements Filter {
    protected static final String X_ORIGINAL_STATUS = "X-Original-Status";
    protected static final String X_WANT_OK_STATUS = "X-Want-Ok-Status";
    private static final Logger logger = LoggerFactory.getLogger(ResponseCodeManglingFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.debug("Added Hide responsecode Filter");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object object;
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            String string = ((HttpServletRequest)servletRequest).getHeader(X_WANT_OK_STATUS);
            if (string != null && !"".equals(string.trim())) {
                logger.debug("Hiding Response Code if necessary");
                object = new HttpReponseOkWrapper((HttpServletResponse)servletResponse);
            } else {
                object = servletResponse;
            }
        } else {
            object = servletResponse;
        }
        filterChain.doFilter(servletRequest, object);
    }

    public void destroy() {
    }

    private class HttpReponseOkWrapper
    extends HttpServletResponseWrapper {
        private HttpReponseOkWrapper(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        public void setStatus(int n) {
            int n2 = this._determineCorrectStatusCode(n);
            super.setStatus(n2);
        }

        private int _determineCorrectStatusCode(int n) {
            this.addHeader(ResponseCodeManglingFilter.X_ORIGINAL_STATUS, Integer.toString(n));
            if (n >= 400) {
                logger.info("Hiding status code {} with {}", (Object)n, (Object)207);
                return 207;
            }
            return n;
        }

        public void setStatus(int n, String string) {
            int n2 = this._determineCorrectStatusCode(n);
            super.setStatus(n2, string);
        }

        public void sendError(int n) throws IOException {
            int n2 = this._determineCorrectStatusCode(n);
            super.sendError(n2);
        }

        public void sendError(int n, String string) throws IOException {
            int n2 = this._determineCorrectStatusCode(n);
            super.sendError(n2, string);
        }
    }
}

