package com.xebialabs.deployit;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.exception.DeployitException;
import org.springframework.stereotype.Component;

// PLEASE NOTE: Do not remove the implemented interface, it is needed by RestEasy, even though the ClosingExceptionMapper also implements it.
@Provider
@Component
public class UnhandledExceptionMapper extends ClosingExceptionMapper<RuntimeException> implements ExceptionMapper<RuntimeException> {

	private static final Logger logger = LoggerFactory.getLogger(UnhandledExceptionMapper.class);

	@Override
	protected Response handleException(RuntimeException exception) {
		logger.debug("Intercepting (possibly) unhandled exception...");
		// Safeguard that we do not by accident handle DeployitExceptions
		if (exception instanceof DeployitException) {
			return new DeployitExceptionMapper().toResponse((DeployitException) exception);
		} else {
			logger.error("Unhandled Exception: {}", exception);
			final Response.ResponseBuilder builder = ResponseFactory.serverError().type(MediaType.APPLICATION_XML);
			builder.header("Unhandled-Exception", "true");
			builder.header("Exception-Type", exception.getClass().getName());
			builder.entity(Sanitizer.sanitize(exception.getMessage()));
			return builder.build();
		}
	}
}
