package com.xebialabs.deployit.jetty;

import com.google.common.collect.Maps;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import java.util.Map;

public class HeaderOverridingRequestWrapper extends HttpServletRequestWrapper {
  private Map<String, String> extraHeaders = Maps.newHashMap();

  /**
   * Constructs a request object wrapping the given request.
   *
   * @throws IllegalArgumentException if the request is null
   */
  public HeaderOverridingRequestWrapper(HttpServletRequest request) {
    super(request);
  }

  public void putHeader(String name, String value) {
    extraHeaders.put(name, value);
  }

  @Override
  public String getHeader(final String name) {
    if (extraHeaders.containsKey(name)) {
      return extraHeaders.get(name);
    }
    return super.getHeader(name);
  }
}
