/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.google.common.base.Strings;
import com.xebialabs.deployit.DeployitConfig;
import com.xebialabs.deployit.DeployitExceptionMapper;
import com.xebialabs.deployit.DeployitOptions;
import com.xebialabs.deployit.UnhandledExceptionMapper;
import com.xebialabs.deployit.core.api.resteasy.ResteasyHelper;
import com.xebialabs.deployit.core.rest.resteasy.OpenJcrSessionDuringRequestInterceptor;
import com.xebialabs.deployit.event.EventBus;
import com.xebialabs.deployit.event.EventCallback;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.jetty.ClassPathResourceContentServlet;
import com.xebialabs.deployit.jetty.MethodOverrideFilter;
import com.xebialabs.deployit.jetty.RequestHeaderOverrideFilter;
import com.xebialabs.deployit.plugin.api.boot.PluginBooter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.jcr.Repository;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.jackrabbit.j2ee.JcrRemotingServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.servlet.DispatcherServlet;

public class Server {
    private final DeployitConfig deployItConfiguration;
    private org.mortbay.jetty.Server jettyServer;
    private Context contextRoot;
    private static volatile CountDownLatch shutdownLatch = new CountDownLatch(1);
    private static final Logger logger;

    public static void start(DeployitOptions deployitOptions) {
        DeployitConfig configuration = DeployitConfig.loadForUse();
        Server server = new Server(configuration, deployitOptions);
        server.start();
    }

    public Server(DeployitConfig configuration, DeployitOptions deployitOptions) {
        this.deployItConfiguration = configuration;
        if (this.portIsAvailable()) {
            this.setupJetty(deployitOptions);
            this.bootPlugins();
            this.setupSpring();
            this.setupRest();
        } else {
            logger.error("Cannot start Deployit server, port " + this.deployItConfiguration.getHttpPort() + " already in use.");
            logger.error("Perhaps another instance of Deployit is running. If so, please shutdown the other instance of Deployit.");
            System.exit(1);
        }
    }

    private void bootPlugins() {
        PluginBooter.boot();
    }

    private boolean portIsAvailable() {
        try {
            ServerSocket socket = new ServerSocket(this.deployItConfiguration.getHttpPort());
            socket.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void start() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting Jetty");
            }
            this.jettyServer.start();
            if (logger.isDebugEnabled()) {
                logger.debug("Jetty started");
            }
            logger.info("The Deployit server has started.");
            String host = (this.deployItConfiguration.isSsl() ? "https" : "http") + "://" + InetAddress.getLocalHost().getHostName() + ":" + this.deployItConfiguration.getHttpPort();
            logger.info("You can now point your browser to {} or start the command line interface with \"cli.sh\" or \"cli.cmd\"", (Object)host);
            Thread shutdownServerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        shutdownLatch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Stopping Jetty.");
                    }
                    try {
                        Server.this.jettyServer.stop();
                        logger.info("Server stopped.");
                    }
                    catch (Exception e) {
                        logger.error("Error occurred while trying to stop Jetty", (Throwable)e);
                    }
                }
            });
            shutdownServerThread.start();
        }
        catch (Exception e) {
            logger.error("Error occured while starting Jetty", (Throwable)e);
        }
    }

    private void setupJetty(DeployitOptions deployitOptions) {
        SocketConnector connector;
        int port = this.deployItConfiguration.getHttpPort();
        String webContextRoot = "/";
        String documentRootPackage = "web";
        if (logger.isDebugEnabled()) {
            logger.debug("Setting up Jetty server on port " + port + " with context root " + webContextRoot + " using package " + documentRootPackage + " for document root.");
        }
        if (this.deployItConfiguration.isSsl()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Setting up Jetty to use SSL");
            }
            this.jettyServer = new org.mortbay.jetty.Server();
            connector = new SslSocketConnector();
            connector.setHost(System.getProperty("jetty.host", "localhost"));
            connector.setPort(port);
            logger.info("Connector listen secure on " + connector.getHost() + ":" + connector.getPort());
            connector.setMaxIdleTime(30000);
            connector.setKeystore(this.deployItConfiguration.getKeyStorePath());
            connector.setPassword(this.deployItConfiguration.getKeyStorePassword());
            connector.setKeyPassword(this.deployItConfiguration.getKeyStoreKeyPassword());
            String protocol = this.deployItConfiguration.getSslProtocol();
            if (!Strings.nullToEmpty((String)protocol).trim().isEmpty()) {
                connector.setProtocol(protocol);
            }
            this.jettyServer.addConnector((Connector)connector);
        } else {
            this.jettyServer = new org.mortbay.jetty.Server();
            connector = new SocketConnector();
            connector.setHost(System.getProperty("jetty.host"));
            connector.setPort(port);
            logger.info("Connector listen no-secure on " + connector.getHost() + ":" + connector.getPort());
            this.jettyServer.addConnector((Connector)connector);
        }
        BoundedThreadPool btp = new BoundedThreadPool();
        btp.setMinThreads(this.deployItConfiguration.getMinThreads());
        btp.setMaxThreads(this.deployItConfiguration.getMaxThreads());
        this.jettyServer.setThreadPool((ThreadPool)btp);
        this.contextRoot = new Context((HandlerContainer)this.jettyServer, webContextRoot, 1);
        this.contextRoot.addFilter(MethodOverrideFilter.class, "*", 1);
        this.contextRoot.addFilter(RequestHeaderOverrideFilter.class, "*", 1);
        ServletHolder documentHolder = new ServletHolder();
        documentHolder.setServlet((Servlet)new ClassPathResourceContentServlet(documentRootPackage));
        this.contextRoot.addServlet(documentHolder, "/");
        if (deployitOptions.isTestModeEnabled()) {
            this.setupJackRabbitAccess();
        }
    }

    private void setupJackRabbitAccess() {
        ServletHolder remotingServletHolder = new ServletHolder((Servlet)new JcrRemotingServlet(){

            protected Repository getRepository() {
                WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
                return (Repository)context.getBean("jcrRepository");
            }
        });
        remotingServletHolder.setName("RepositoryAccessServlet");
        String repositoryPrefix = "/repository-test";
        remotingServletHolder.setInitParameter("resource-path-prefix", repositoryPrefix);
        this.contextRoot.addServlet(remotingServletHolder, repositoryPrefix + "/*");
        ServletHolder webdavServletHolder = new ServletHolder((Servlet)new JcrRemotingServlet(){

            public Repository getRepository() {
                WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
                return (Repository)context.getBean("jcrRepository");
            }
        });
        webdavServletHolder.setName("Webdav");
        repositoryPrefix = "/repository";
        webdavServletHolder.setInitParameter("resource-path-prefix", repositoryPrefix);
        webdavServletHolder.setInitParameter("missing-auth-mapping", "guestcredentials");
        this.contextRoot.addServlet(webdavServletHolder, repositoryPrefix + "/*");
    }

    private void setupSpring() {
        Map params = this.contextRoot.getInitParams();
        params.put("contextConfigLocation", "classpath:spring/deployit-context.xml");
        if (logger.isDebugEnabled()) {
            logger.debug("Using Spring configuration - " + (String)params.get("contextConfigLocation"));
        }
        this.contextRoot.addEventListener((EventListener)new ContextLoaderListener(){

            public void contextInitialized(ServletContextEvent event) {
                try {
                    super.contextInitialized(event);
                }
                catch (Exception exc) {
                    logger.error("Exception received while initializing the Spring context in the server. Exiting...", (Throwable)exc);
                    System.exit(1);
                }
            }
        });
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        this.contextRoot.addFilter(filter, "/deployit/*", 1);
    }

    private void setupRest() {
        ServletHolder servletHolder = new ServletHolder(DispatcherServlet.class);
        this.contextRoot.getInitParams().put("resteasy.servlet.mapping.prefix", "/deployit");
        servletHolder.setInitParameter("contextConfigLocation", "classpath*:springmvc-servlet.xml");
        this.contextRoot.addServlet(servletHolder, "/deployit/*");
        this.contextRoot.setResourceBase(".");
        ResteasyHelper.buildDefaultResteasyProviderFactory().addExceptionMapper(new Class[]{DeployitExceptionMapper.class, UnhandledExceptionMapper.class}).addPreProcessInterceptor(new Class[]{OpenJcrSessionDuringRequestInterceptor.class}).addPostProcessInterceptor(new Class[]{OpenJcrSessionDuringRequestInterceptor.class}).build();
    }

    public static void requestShutdown() {
        logger.info("Received message to shutdown the server.");
        shutdownLatch.countDown();
    }

    public static boolean hasShutdownBeenrequested() {
        return shutdownLatch.getCount() == 0L;
    }

    static {
        EventBus.registerForEvent(ShutdownEvent.class, (EventCallback)new EventCallback<ShutdownEvent>(){

            public void receive(ShutdownEvent event) {
                Server.requestShutdown();
            }
        });
        logger = LoggerFactory.getLogger(Server.class);
    }
}

