/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.DeployitConfig;
import com.xebialabs.deployit.DeployitOptions;
import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.Server;
import com.xebialabs.deployit.setup.Setup;
import java.io.OutputStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

public class DeployitBootstrapper {
    private static final Logger logger = LoggerFactory.getLogger(DeployitBootstrapper.class);

    public static void main(String[] args) {
        DeployitOptions deployitOptions = DeployitBootstrapper.parseCommandLine(args);
        if (deployitOptions == null) {
            return;
        }
        SecurityContextHolder.setStrategyName((String)"MODE_INHERITABLETHREADLOCAL");
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
        logger.info("Deployit version " + releaseInfo.getVersion() + " (built at " + releaseInfo.getDate() + ")");
        logger.info("(c) 2008-2011 XebiaLabs");
        DeployitConfig configuration = new DeployitConfig();
        if (deployitOptions.isDoSetup()) {
            DeployitBootstrapper.startSetup(deployitOptions);
        } else {
            if (!configuration.exists()) {
                logger.error("Configuration not found...");
                DeployitBootstrapper.startSetup(deployitOptions);
            }
            DeployitBootstrapper.startServer(deployitOptions);
        }
    }

    private static DeployitOptions parseCommandLine(String[] args) {
        DeployitOptions options = new DeployitOptions();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -cp deployit-server-<version>.jar [options...] com.xebialabs.deployit.Deployit arguments...");
            parser.printUsage((OutputStream)System.err);
            return null;
        }
        return options;
    }

    private static void startServer(DeployitOptions deployitOptions) {
        logger.info("Starting server...");
        Server.start(deployitOptions);
    }

    private static void startSetup(DeployitOptions deployitOptions) {
        logger.info("Starting setup...");
        Setup.setup(deployitOptions);
    }
}

