package com.xebialabs.deployit.jetty;

import com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

public class RequestHeaderOverrideFilter implements Filter {

	public static final String QUERY_PARAM = "acceptHeader";

	private String queryParam;

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
		queryParam = filterConfig.getInitParameter(QUERY_PARAM);
		if (Strings.isNullOrEmpty(queryParam)) {
			queryParam = HttpHeaderOverrideServletRequest.DEFAULT_QUERY_PARAM;
		}
		logger.info("Initialized to check for QueryString Variable {}", QUERY_PARAM);
	}
	
	@Override
	public void destroy() {
		//empty
	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		ServletRequest filteredRequest = request;
		if (request instanceof HttpServletRequest) {
			filteredRequest = processRequest(request);
		}
		chain.doFilter(filteredRequest, response);
	}

	private ServletRequest processRequest(ServletRequest request) {
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		return new HttpHeaderOverrideServletRequest(httpRequest, QUERY_PARAM);
	}

	
	private static Logger logger = LoggerFactory.getLogger(RequestHeaderOverrideFilter.class);

}
