package com.xebialabs.deployit;

import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public class DeployitExceptionMapper implements ExceptionMapper<DeployitException> {

	@Override
	public Response toResponse(DeployitException exception) {
		logger.info("Intercepting DeployitException", exception);
		final HttpResponseCodeResult annotation = exception.getClass().getAnnotation(HttpResponseCodeResult.class);
		int status = 500;
		if (annotation != null) {
			status = annotation.statusCode();
		}
		final Response.ResponseBuilder builder = ResponseFactory.status(status).type(MediaType.APPLICATION_XML);
		builder.header("Deployit-Exception", "true");
		builder.header("Exception-Type", exception.getClass().getName());
		final Response response = builder.entity(exception.getMessage()).build();
		logger.info("Returning response {}", response);
		return response;
	}

	private static final Logger logger = LoggerFactory.getLogger(DeployitExceptionMapper.class);

}
