package com.xebialabs.deployit;

import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.web.filter.OncePerRequestFilter;

import jakarta.servlet.*;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class LicenseExpiryCheckFilter extends OncePerRequestFilter {

    private static final Logger logger = LoggerFactory.getLogger(LicenseExpiryCheckFilter.class);

    private LicenseService licenseService;

    private Integer daysBeforeWarning;

    public LicenseExpiryCheckFilter(LicenseService licenseService, Integer daysBeforeWarning) {
        this.licenseService = licenseService;
        this.daysBeforeWarning = daysBeforeWarning;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest && response instanceof HttpServletResponse)) return;

        License license = licenseService.getLicense();
        Period validPeriod = licenseService.getValidPeriod();

        Authentication authentication = Permissions.getAuthentication();
        boolean hasAuthentication = null != authentication;

        boolean licenseExpiringSoon = validPeriod.getDays() < daysBeforeWarning;
        if (hasAuthentication && PermissionHelper.isCurrentUserAdmin()
                && licenseExpiringSoon) {
            response.setHeader("LICENSE-EXPIRY-DATE",
                    license.getStringValue(LicenseProperty.EXPIRES_AFTER));
        }

        filterChain.doFilter(request, response);

    }

    @Override
    public void destroy() {
        // Empty
    }
}
