package com.xebialabs.deployit

import java.io.IOException

import jakarta.servlet.http.HttpServletRequest
import jakarta.servlet.{FilterChain, ServletException, ServletRequest, ServletResponse}
import org.springframework.security.core.context.SecurityContextHolder
import org.springframework.web.filter.GenericFilterBean

/**
  * The filter that saves the Spring Security attributes for Logback-access.
  */
class LogbackAccessSecurityAttributesSaveFilter extends GenericFilterBean {

  @throws[IOException]
  @throws[ServletException]
  override def doFilter(request: ServletRequest, response: ServletResponse, chain: FilterChain): Unit = {
    try {
      saveSecurityAttributes(request.asInstanceOf[HttpServletRequest])
    } catch {
      case _: RuntimeException => //ignore
    }
    chain.doFilter(request, response)
  }

  /**
    * Save Remote User in a request attribute.
    */
  private def saveSecurityAttributes(request: HttpServletRequest): Unit =
    Option(SecurityContextHolder.getContext.getAuthentication).foreach(a =>
      request.setAttribute(LogbackAccessSecurityAttributesSaveFilter.remoteUserAttribute, a.getName)
    )
}

object LogbackAccessSecurityAttributesSaveFilter {

  /**
    * The attribute name of the remote user.
    */
  val remoteUserAttribute: String = classOf[LogbackAccessSecurityAttributesSaveFilter].getName + ".remoteUser"
}
